/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.StreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import jetbrains.buildServer.util.ArchiveType;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.TCStreamUtil;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArchiveUtil {
    public static final String DEFAULT_ZIP_ENCODING = "cp437";
    private static final Logger LOG = Logger.getInstance((String)ArchiveUtil.class.getName());
    private static final String GZ = ".gz";

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static ArchiveType getArchiveType(@NotNull String name) {
        ArchiveType archiveType;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.getArchiveType must not be null");
        }
        if ((name = name.toLowerCase()).endsWith(".zip") || name.endsWith(".nupkg") || name.endsWith(".sit")) {
            archiveType = ArchiveType.ZIP;
            if (archiveType == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/ArchiveUtil.getArchiveType must not return null");
            return archiveType;
        }
        if (name.endsWith(".jar") || name.endsWith(".war") || name.endsWith(".ear") || name.endsWith(".apk")) {
            archiveType = ArchiveType.JAR;
            if (archiveType == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/ArchiveUtil.getArchiveType must not return null");
            return archiveType;
        }
        if (name.endsWith(".tar.gz") || name.endsWith(".tgz") || name.endsWith(".tar.gzip")) {
            archiveType = ArchiveType.TAR_GZ;
            if (archiveType == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/ArchiveUtil.getArchiveType must not return null");
            return archiveType;
        }
        if (name.endsWith(".tar")) {
            archiveType = ArchiveType.TAR;
            if (archiveType == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/ArchiveUtil.getArchiveType must not return null");
            return archiveType;
        }
        archiveType = ArchiveType.NOT_ARCHIVE;
        if (archiveType != null) return archiveType;
        throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/ArchiveUtil.getArchiveType must not return null");
    }

    @Nullable
    public static ArchiveInputStream getArchiveInputStream(@NotNull ArchiveType archiveType, @NotNull InputStream inputStream) throws IOException {
        if (archiveType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.getArchiveInputStream must not be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.getArchiveInputStream must not be null");
        }
        return archiveType == ArchiveType.ZIP ? new ZipArchiveInputStream(inputStream, DEFAULT_ZIP_ENCODING, true) : (archiveType == ArchiveType.JAR ? new JarArchiveInputStream(inputStream) : (archiveType == ArchiveType.TAR_GZ ? new TarArchiveInputStream((InputStream)new GZIPInputStream(inputStream)) : (archiveType == ArchiveType.TAR ? new TarArchiveInputStream(inputStream) : null)));
    }

    @Nullable
    public static ArchiveInputStream getArchiveInputStream(@NotNull String name, @NotNull InputStream inputStream) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.getArchiveInputStream must not be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.getArchiveInputStream must not be null");
        }
        return ArchiveUtil.getArchiveInputStream(ArchiveUtil.getArchiveType(name), inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unpackZip(@NotNull File zip, @NotNull String pathPrefix, @NotNull File targetDir) {
        if (zip == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.unpackZip must not be null");
        }
        if (pathPrefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.unpackZip must not be null");
        }
        if (targetDir == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.unpackZip must not be null");
        }
        LOG.debug("Start unpacking " + zip.getName() + "!" + pathPrefix + " => " + targetDir);
        ZipInputStream file = null;
        try {
            file = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip)));
            ArchiveUtil.unpackZip(file, targetDir, pathPrefix);
        }
        catch (IOException e) {
            boolean bl;
            try {
                LOG.warn("Failed to unpack jar file: " + zip.getAbsolutePath(), (Throwable)e);
                bl = false;
            }
            catch (Throwable throwable) {
                FileUtil.close(file);
                throw throwable;
            }
            FileUtil.close(file);
            return bl;
        }
        FileUtil.close(file);
        return true;
    }

    public static boolean unpackZip(@NotNull ZipInputStream input, @NotNull File targetDir) {
        if (input == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.unpackZip must not be null");
        }
        if (targetDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.unpackZip must not be null");
        }
        try {
            ArchiveUtil.unpackZip(input, targetDir, "");
        }
        catch (IOException e) {
            LOG.warn("Failed to unpack zip input stream", (Throwable)e);
            return false;
        }
        return true;
    }

    private static void unpackZip(@NotNull ZipInputStream file, @NotNull File targetDir, @NotNull String pathPrefix) throws IOException {
        ZipEntry ze;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.unpackZip must not be null");
        }
        if (targetDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.unpackZip must not be null");
        }
        if (pathPrefix == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.unpackZip must not be null");
        }
        while ((ze = file.getNextEntry()) != null) {
            if (!ze.getName().startsWith(pathPrefix)) continue;
            LOG.debug("Extracting " + ze.getName() + " => " + targetDir);
            ArchiveUtil.saveEntry(targetDir, file, ze, pathPrefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void saveEntry(@NotNull File parentDir, @NotNull ZipInputStream zf, @NotNull ZipEntry entry, @NotNull String pathPrefix) throws IOException {
        if (parentDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.saveEntry must not be null");
        }
        if (zf == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.saveEntry must not be null");
        }
        if (entry == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.saveEntry must not be null");
        }
        if (pathPrefix == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.saveEntry must not be null");
        }
        String relativePath = entry.getName().substring(pathPrefix.length());
        if (relativePath.startsWith("/") || relativePath.startsWith("\\")) {
            relativePath = relativePath.substring(1);
        }
        File file = new File(parentDir, relativePath);
        FileUtil.createParentDirs((File)file);
        LOG.debug("Unpack to " + file);
        if (entry.isDirectory()) {
            file.mkdirs();
            return;
        }
        if (file.exists()) {
            FileUtil.delete((File)file);
        }
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        try {
            TCStreamUtil.writeBinary(new BufferedInputStream(zf), bos);
        }
        catch (Throwable throwable) {
            FileUtil.closeAll(bos);
            throw throwable;
        }
        FileUtil.closeAll(bos);
    }

    public static boolean packZip(File root, ZipOutputStream output) {
        return ArchiveUtil.packZip(root, null, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean packZip(File root, FilenameFilter filter, ZipOutputStream output) {
        try {
            byte[] buffer = new byte[65536];
            try {
                ArchiveUtil.traverseAndWrite(root, filter, output, new StringBuilder(), true, buffer);
            }
            finally {
                output.close();
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to pack files to a zip file", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traverseAndWrite(File file, FilenameFilter filter, ZipOutputStream output, StringBuilder pathBuilder, boolean isFirst, byte[] buffer) throws IOException {
        if (!isFirst) {
            pathBuilder.append(file.getName());
            if (!file.isFile()) {
                pathBuilder.append('/');
            }
        }
        if (file.isFile()) {
            String path = pathBuilder.toString();
            ZipEntry zipEntry = new ZipEntry(path);
            zipEntry.setTime(file.lastModified());
            output.putNextEntry(zipEntry);
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            try {
                int read;
                do {
                    read = ((InputStream)input).read(buffer);
                    output.write(buffer, 0, Math.max(read, 0));
                } while (read == buffer.length);
            }
            catch (IOException e) {
                LOG.warn("Failed to pack file in a zip: " + file.getAbsolutePath() + " (error: " + e.getMessage() + ")");
                LOG.debug((Throwable)e);
            }
            finally {
                ((InputStream)input).close();
            }
        } else {
            File[] files;
            File[] fileArray = files = filter == null ? file.listFiles() : file.listFiles(filter);
            if (files != null) {
                int length = pathBuilder.length();
                for (File innerFile : files) {
                    ArchiveUtil.traverseAndWrite(innerFile, filter, output, pathBuilder, false, buffer);
                    pathBuilder.setLength(length);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void packStream(@NotNull OutputStream out, @NotNull InputStream in) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.packStream must not be null");
        }
        if (in == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.packStream must not be null");
        }
        GZIPOutputStream gz = new GZIPOutputStream(out);
        try {
            StreamUtil.copyStreamContent((InputStream)in, (OutputStream)gz);
        }
        finally {
            gz.finish();
        }
    }

    public static void unpackStream(@NotNull OutputStream out, @NotNull InputStream in) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.unpackStream must not be null");
        }
        if (in == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.unpackStream must not be null");
        }
        StreamUtil.copyStreamContent((InputStream)new GZIPInputStream(in), (OutputStream)out);
    }

    @Nullable
    public static byte[] packBytes(byte[] unpacked) {
        try {
            if (unpacked == null) {
                return null;
            }
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            ArchiveUtil.packStream(bas, new ByteArrayInputStream(unpacked));
            return bas.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to pack bytes", e);
        }
    }

    @Nullable
    public static byte[] unpackBytes(byte[] packed) {
        try {
            if (packed == null) {
                return null;
            }
            ByteArrayOutputStream result = new ByteArrayOutputStream(packed.length);
            ArchiveUtil.unpackStream(result, new ByteArrayInputStream(packed));
            return result.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to unpack bytes", e);
        }
    }

    @Nullable
    public static InputStream extractEntry(@NotNull ZipInputStream input, @NotNull String path) throws IOException {
        ZipEntry entry;
        if (input == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.extractEntry must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.extractEntry must not be null");
        }
        while ((entry = input.getNextEntry()) != null) {
            if (!entry.getName().equals(path)) continue;
            return input;
        }
        return null;
    }

    @NotNull
    public static File getPackedFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.getPackedFile must not be null");
        }
        File parentFile = file.getParentFile();
        String packedFileName = ArchiveUtil.getPackedFileName(file.getName());
        File file2 = parentFile != null ? new File(parentFile, packedFileName) : new File(packedFileName);
        if (file2 == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/ArchiveUtil.getPackedFile must not return null");
        }
        return file2;
    }

    @NotNull
    public static String getPackedFileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.getPackedFileName must not be null");
        }
        String string = fileName + GZ;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/ArchiveUtil.getPackedFileName must not return null");
        }
        return string;
    }

    public static boolean isPackedFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.isPackedFile must not be null");
        }
        return ArchiveUtil.isPackedFileName(file.getName());
    }

    public static boolean isPackedFileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.isPackedFileName must not be null");
        }
        return fileName.endsWith(GZ);
    }

    @NotNull
    public static File packFile(@NotNull File srcFile) throws IOException {
        if (srcFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/ArchiveUtil.packFile must not be null");
        }
        File packedFile = ArchiveUtil.getPackedFile(srcFile);
        ArchiveUtil.packFileTo(packedFile, srcFile);
        File file = packedFile;
        if (file == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/ArchiveUtil.packFile must not return null");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void packFileTo(File dstFile, File srcFile) throws IOException {
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            input = new FileInputStream(srcFile);
            output = new FileOutputStream(dstFile);
            ArchiveUtil.packStream(output, input);
        }
        catch (Throwable throwable) {
            FileUtil.close(input);
            FileUtil.close(output);
            throw throwable;
        }
        FileUtil.close(input);
        FileUtil.close(output);
    }
}

