/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import jetbrains.buildServer.util.FileUtil;
import org.jetbrains.annotations.NotNull;

public class CloseAwareInputStream
extends InputStream {
    @NotNull
    private final InputStream myDelegate;
    @NotNull
    private final AtomicBoolean myIsClosed;

    public CloseAwareInputStream(@NotNull InputStream delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/CloseAwareInputStream.<init> must not be null");
        }
        this.myDelegate = delegate;
        this.myIsClosed = new AtomicBoolean(false);
    }

    public long skip(long n) throws IOException {
        return this.myDelegate.skip(n);
    }

    public int read() throws IOException {
        return this.myDelegate.read();
    }

    public int read(byte[] b) throws IOException {
        return this.myDelegate.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.myDelegate.read(b, off, len);
    }

    public void close() {
        if (this.myIsClosed.compareAndSet(false, true)) {
            this.doClose();
        }
    }

    protected void doClose() {
        FileUtil.close(this.myDelegate);
    }

    public int available() throws IOException {
        return this.myDelegate.available();
    }
}

