/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.util.EventDispatcherHandlers;
import jetbrains.buildServer.util.ExceptionUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDispatcher<T extends EventListener> {
    private static final Logger LOG = Logger.getInstance((String)EventDispatcher.class.getName());
    private static final long THRESHOLD = 10000L;
    private final T myMulticaster;
    @NotNull
    private final EventDispatcherHandlers<T> myHanders;
    @Nullable
    private volatile Map<Method, T[]> myMethodsToCall;
    @Nullable
    private ErrorHandler myErrorHandler;
    public static final ErrorHandler DEFAULT_ERROR_HANDLER = new ErrorHandler(){

        public void handle(Throwable e) {
            LOG.warn("Error in event handler", e);
        }
    };

    public static <T extends EventListener> EventDispatcher<T> create(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/EventDispatcher.create must not be null");
        }
        return new EventDispatcher<T>(listenerClass);
    }

    protected EventDispatcher(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/EventDispatcher.<init> must not be null");
        }
        this.myMethodsToCall = null;
        this.myErrorHandler = DEFAULT_ERROR_HANDLER;
        this.myHanders = new EventDispatcherHandlers<T>(listenerClass);
        InvocationHandler handler = new InvocationHandler(){

            @NonNls
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return EventDispatcher.this.dispatch(proxy, method, args);
            }
        };
        this.myMulticaster = (EventListener)listenerClass.cast(Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler));
    }

    public T getMulticaster() {
        return this.myMulticaster;
    }

    @Nullable
    public ErrorHandler getErrorHandler() {
        return this.myErrorHandler;
    }

    public void setErrorHandler(@Nullable ErrorHandler errorHandler) {
        this.myErrorHandler = errorHandler;
    }

    public void clearErrorHandler() {
        this.myErrorHandler = null;
    }

    protected Object dispatch(Object proxy, Method method, Object[] args) {
        if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
            String methodName = method.getName();
            if (methodName.equals("toString")) {
                return "Multicaster";
            }
            if (methodName.equals("hashCode")) {
                return new Integer(System.identityHashCode(proxy));
            }
            if (methodName.equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            LOG.error("Incorrect Object's method invoked for proxy:" + methodName);
            return null;
        }
        for (EventListener listener : (EventListener[])this.getCachedListeners().get(method)) {
            try {
                long startTime = System.currentTimeMillis();
                method.invoke((Object)listener, args);
                long finishTime = System.currentTimeMillis();
                if (finishTime - startTime <= 10000L) continue;
                LOG.debug("Method " + listener.getClass().getName() + "." + method.getName() + " took " + (double)(finishTime - startTime) / 1000.0 + " seconds to complete. To avoid deadlocks listeners should not take much time to execute.");
            }
            catch (AbstractMethodError e) {
            }
            catch (Throwable e) {
                Throwable error = e.getCause() != null ? e.getCause() : e;
                ErrorHandler eh = this.myErrorHandler;
                if (eh == null) {
                    ExceptionUtil.rethrowAsRuntimeException(error);
                }
                eh.handle(error);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Map<Method, T[]> getCachedListeners() {
        Map<Method, T[]> map;
        Map<Method, T[]> methodsToCall = this.myMethodsToCall;
        if (methodsToCall != null) {
            map = methodsToCall;
            if (map == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/EventDispatcher.getCachedListeners must not return null");
            return map;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            methodsToCall = this.myMethodsToCall;
            if (methodsToCall != null) {
                Map<Method, T[]> map2 = methodsToCall;
                // MONITOREXIT @DISABLED, blocks:[2, 8] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                map = map2;
                if (map2 == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/EventDispatcher.getCachedListeners must not return null");
                return map;
            }
            this.myMethodsToCall = this.myHanders.serialize();
        }
        map = this.myMethodsToCall;
        if (this.myMethodsToCall != null) return map;
        throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/EventDispatcher.getCachedListeners must not return null");
    }

    public synchronized void addListener(T listener) {
        this.myHanders.addListener(listener);
        this.resetListenersCache();
    }

    private void resetListenersCache() {
        this.myMethodsToCall = null;
    }

    public synchronized void removeListener(T listener) {
        this.myHanders.removeListener(listener);
        this.resetListenersCache();
    }

    @NotNull
    public synchronized List<T> getListeners() {
        List<T> list = this.myHanders.getListeners();
        if (list == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/EventDispatcher.getListeners must not return null");
        }
        return list;
    }

    public synchronized boolean hasListeners() {
        return this.myHanders.hasListeners();
    }

    public synchronized void dispose() {
        this.myHanders.clear();
        this.resetListenersCache();
    }

    public static interface ErrorHandler {
        public void handle(Throwable var1);
    }
}

