/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import org.jetbrains.annotations.NotNull;

public class ExponentialBackoffHelper {
    @NotNull
    private static final int[] PWR_2 = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    private static final int MAX_COLLISIONS = PWR_2.length - 1;
    private int myCollisions = 0;

    public void reset() {
        this.myCollisions = 0;
    }

    public int computeDelayForCollision(int slotTime) {
        if (this.myCollisions < MAX_COLLISIONS) {
            ++this.myCollisions;
        }
        int slotsCount = 1 + (int)((double)(PWR_2[this.myCollisions] - 1) * Math.random());
        return slotsCount * slotTime;
    }
}

