/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Option<Type> {
    private static Map<String, Option> ourOptions = new HashMap<String, Option>();
    private final String myKey;
    private final Type myDefaultValue;

    public Option(@NonNls @NotNull String key, @NotNull Type defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/Option.<init> must not be null");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/Option.<init> must not be null");
        }
        this.myKey = key;
        this.myDefaultValue = defaultValue;
        ourOptions.put(key, this);
    }

    public abstract Type fromString(String var1);

    public abstract String toString(Type var1);

    @Nullable
    public static Option fromKey(String key) {
        return ourOptions.get(key);
    }

    @NotNull
    public String getKey() {
        String string = this.myKey;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/Option.getKey must not return null");
        }
        return string;
    }

    @NotNull
    public Type getDefaultValue() {
        Type Type2 = this.myDefaultValue;
        if (Type2 == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/Option.getDefaultValue must not return null");
        }
        return Type2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Option option = (Option)o;
        return !(this.myKey == null ? option.myKey != null : !this.myKey.equals(option.myKey));
    }

    public int hashCode() {
        return this.myKey != null ? this.myKey.hashCode() : 0;
    }

    public String toString() {
        return this.myKey;
    }
}

