/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.PEReader;

import java.io.IOException;
import java.io.RandomAccessFile;
import jetbrains.buildServer.util.PEReader.BinaryUtils;
import jetbrains.buildServer.util.PEReader.InvalidSignatureException;

public class PEImageFileHeader {
    public static final long IMAGE_NT_SIGNATURE = 17744L;
    private int myNumberOfSections;
    private int mySizeOfOptionalHeader;

    public static PEImageFileHeader read(RandomAccessFile raf) throws IOException, InvalidSignatureException {
        if (BinaryUtils.readUInt32(raf) != 17744L) {
            throw new InvalidSignatureException("IMAGE_NT_SIGNATURE was not found");
        }
        PEImageFileHeader res = new PEImageFileHeader();
        BinaryUtils.readUInt16(raf);
        res.myNumberOfSections = BinaryUtils.readUInt16(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt32(raf);
        res.mySizeOfOptionalHeader = BinaryUtils.readUInt16(raf);
        BinaryUtils.readUInt16(raf);
        return res;
    }

    public int getNumberOfSections() {
        return this.myNumberOfSections;
    }

    public int getSizeOfOptionalHeader() {
        return this.mySizeOfOptionalHeader;
    }
}

