/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.PEReader;

import java.io.IOException;
import java.io.RandomAccessFile;
import jetbrains.buildServer.util.PEReader.BinaryUtils;
import jetbrains.buildServer.util.PEReader.PEImageDataDirectory;

public class PEImageOptionalHeader {
    public static final int IMAGE_NUMBEROF_DIRECTORY_ENTRIES = 16;
    public static final int IMAGE_DIRECTORY_ENTRY_EXPORT = 0;
    public static final int IMAGE_DIRECTORY_ENTRY_IMPORT = 1;
    public static final int IMAGE_DIRECTORY_ENTRY_RESOURCE = 2;
    public static final int IMAGE_DIRECTORY_ENTRY_EXCEPTION = 3;
    public static final int IMAGE_DIRECTORY_ENTRY_SECURITY = 4;
    public static final int IMAGE_DIRECTORY_ENTRY_BASERELOC = 5;
    public static final int IMAGE_DIRECTORY_ENTRY_DEBUG = 6;
    public static final int IMAGE_DIRECTORY_ENTRY_COPYRIGHT = 7;
    public static final int IMAGE_DIRECTORY_ENTRY_GLOBALPTR = 8;
    public static final int IMAGE_DIRECTORY_ENTRY_TLS = 9;
    public static final int IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG = 10;
    public static final int MAGIC_PE32 = 267;
    public static final int MAGIC_ROM = 263;
    public static final int MAGIC_PE32PLUS = 523;
    private int myMagic;
    private PEImageDataDirectory[] myDataDirectories;

    private PEImageOptionalHeader() {
    }

    public static PEImageOptionalHeader read(RandomAccessFile raf) throws IOException {
        PEImageOptionalHeader res = new PEImageOptionalHeader();
        res.myMagic = BinaryUtils.readUInt16(raf);
        BinaryUtils.readUInt8(raf);
        BinaryUtils.readUInt8(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt16(raf);
        BinaryUtils.readUInt16(raf);
        BinaryUtils.readUInt16(raf);
        BinaryUtils.readUInt16(raf);
        BinaryUtils.readUInt16(raf);
        BinaryUtils.readUInt16(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt16(raf);
        BinaryUtils.readUInt16(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt32(raf);
        res.myDataDirectories = new PEImageDataDirectory[16];
        for (int i = 0; i < 16; ++i) {
            res.myDataDirectories[i] = PEImageDataDirectory.read(raf);
        }
        return res;
    }

    public PEImageDataDirectory[] getDataDirectories() {
        return this.myDataDirectories;
    }

    public int getMagic() {
        return this.myMagic;
    }
}

