/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.PEReader;

import java.io.IOException;
import java.io.RandomAccessFile;
import jetbrains.buildServer.util.PEReader.BinaryUtils;

public class PEImageResourceDirectoryEntry {
    public static final int RT_VERSION = 16;
    private long myName;
    private long myOffsetToData;
    private long myNameOffset;
    private int myId;
    private boolean myIsDirectory;
    private boolean myNameIsString;
    private long myOffsetToDirectory;

    private PEImageResourceDirectoryEntry() {
    }

    public static PEImageResourceDirectoryEntry read(RandomAccessFile raf) throws IOException {
        PEImageResourceDirectoryEntry res = new PEImageResourceDirectoryEntry();
        res.myName = BinaryUtils.readUInt32(raf);
        res.myOffsetToData = BinaryUtils.readUInt32(raf);
        res.myNameIsString = (res.myName & 0x80000000L) != 0L;
        res.myNameOffset = res.myName & Integer.MAX_VALUE;
        res.myId = (int)(res.myName & 0xFFFFL);
        res.myOffsetToDirectory = res.myOffsetToData & Integer.MAX_VALUE;
        res.myIsDirectory = (res.myOffsetToData & 0x80000000L) != 0L;
        return res;
    }

    public long getName() {
        return this.myName;
    }

    public long getOffsetToData() {
        return this.myOffsetToData;
    }

    public long getNameOffset() {
        return this.myNameOffset;
    }

    public int getId() {
        return this.myId;
    }

    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    public long getOffsetToDirectory() {
        return this.myOffsetToDirectory;
    }

    public boolean nameIsString() {
        return this.myNameIsString;
    }

    public String toString() {
        String dir;
        String string = dir = this.isDirectory() ? "DIR:" : "ENTRY:";
        if (this.nameIsString()) {
            return dir + "NAME";
        }
        return dir + "ID:" + this.myId;
    }
}

