/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import jetbrains.buildServer.util.StringUtil;

public class PluralUtil {
    private static final char[] ourVowels = new char[]{'a', 'e', 'i', 'j', 'o', 'u', 'y'};
    private static final String[] ourEs = new String[]{"s", "ch", "sh", "x"};

    public static String toPluralIfNeeded(String name, int count) {
        Object[] strings = name.split("/");
        for (int i = 0; i < strings.length; ++i) {
            String name1 = strings[i];
            strings[i] = count == 1 ? PluralUtil.toSingular(name1) : PluralUtil.toPlural(name1);
        }
        return StringUtil.join("/", strings);
    }

    public static String toPlural(String name) {
        String plainName = PluralUtil.getPlainName(name);
        String ending = name.substring(plainName.length());
        if (plainName.length() < 3 || PluralUtil.isPlural(plainName)) {
            return name;
        }
        StringBuffer sb = new StringBuffer(plainName);
        if (plainName.endsWith("child")) {
            sb.append("ren");
        } else if (plainName.endsWith("y") && !PluralUtil.isVowel(plainName.charAt(plainName.length() - 2))) {
            PluralUtil.removeLastChars(sb, 1);
            sb.append("ies");
        } else if (plainName.endsWith("z")) {
            sb.append("zes");
        } else if (PluralUtil.isEsEnding(plainName, false)) {
            sb.append("es");
        } else if (!plainName.endsWith("s")) {
            sb.append("s");
        }
        sb.append(ending);
        return sb.toString();
    }

    public static String toSingular(String name) {
        String plainName = PluralUtil.getPlainName(name);
        String ending = name.substring(plainName.length());
        if (plainName.length() < 3 || !PluralUtil.isPlural(plainName)) {
            return name;
        }
        StringBuffer sb = new StringBuffer(plainName);
        if (plainName.endsWith("ildren")) {
            PluralUtil.removeLastChars(sb, 3);
        } else if (plainName.endsWith("ies")) {
            PluralUtil.removeLastChars(sb, 3);
            sb.append("y");
        } else if (plainName.endsWith("zes")) {
            PluralUtil.removeLastChars(sb, 3);
        } else if (PluralUtil.isEsEnding(plainName, true)) {
            PluralUtil.removeLastChars(sb, 2);
        } else if (plainName.endsWith("s")) {
            PluralUtil.removeLastChars(sb, 1);
        }
        sb.append(ending);
        return sb.toString();
    }

    private static boolean isPlural(String name) {
        if (name.endsWith("ildren")) {
            return true;
        }
        if (name.endsWith("child")) {
            return false;
        }
        char beforeLast = name.charAt(name.length() - 2);
        return name.endsWith("es") || name.endsWith("s") && (!PluralUtil.isVowel(beforeLast) || beforeLast == 'o' || beforeLast == 'y' || beforeLast == 'a');
    }

    private static String getPlainName(String name) {
        int i;
        for (i = name.length() - 1; i >= 0 && !Character.isLetter(name.charAt(i)); --i) {
        }
        return name.substring(0, i + 1);
    }

    private static void removeLastChars(StringBuffer sb, int count) {
        sb.delete(sb.length() - count, sb.length());
    }

    private static boolean isVowel(char c) {
        for (char ourVowel : ourVowels) {
            if (ourVowel != c && ourVowel != Character.toLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEsEnding(String s, boolean withEs) {
        for (String esEnding : ourEs) {
            if (withEs && s.endsWith(esEnding + "es")) {
                return true;
            }
            if (withEs || !s.endsWith(esEnding)) continue;
            return true;
        }
        return false;
    }
}

