/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.util.text.LineReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static boolean getBoolean(String value) {
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    public static boolean isEmptyOrNull(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static Integer parseInt(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static int compareProperties(Map<String, String> props1, Map<String, String> props2) {
        int commonProps = 0;
        for (String name : props1.keySet()) {
            if (!props1.get(name).equals(props2.get(name))) continue;
            ++commonProps;
        }
        if (props1.size() == commonProps) {
            return props2.size() - commonProps;
        }
        if (props2.size() == commonProps) {
            return commonProps - props1.size();
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Properties loadProperties(File propertiesFile) throws IOException {
        Properties properties;
        if (propertiesFile == null) {
            properties = new Properties();
            if (properties == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/PropertiesUtil.loadProperties must not return null");
            return properties;
        }
        properties = PropertiesUtil.loadProperties(new FileInputStream(propertiesFile));
        if (properties != null) return properties;
        throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/PropertiesUtil.loadProperties must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Properties loadPropertiesZipped(File propertiesFile) throws IOException {
        Properties properties;
        if (propertiesFile == null) {
            properties = new Properties();
            if (properties == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/PropertiesUtil.loadPropertiesZipped must not return null");
            return properties;
        }
        properties = PropertiesUtil.loadProperties(new GZIPInputStream(new BufferedInputStream(new FileInputStream(propertiesFile))));
        if (properties != null) return properties;
        throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/PropertiesUtil.loadPropertiesZipped must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Properties loadProperties(@Nullable InputStream inputStream) throws IOException {
        Properties properties;
        Properties properties2;
        if (inputStream == null) {
            properties2 = new Properties();
            if (properties2 == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/PropertiesUtil.loadProperties must not return null");
            return properties2;
        }
        BufferedInputStream inStream = null;
        try {
            inStream = new BufferedInputStream(inputStream);
            Properties properties3 = new Properties();
            properties3.load(inStream);
            properties = properties3;
        }
        catch (Throwable throwable) {
            PropertiesUtil.close(inStream);
            throw throwable;
        }
        PropertiesUtil.close(inStream);
        properties2 = properties;
        if (properties2 != null) return properties2;
        throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/PropertiesUtil.loadProperties must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Properties loadPropertiesXml(File propertiesFile) throws IOException {
        Properties properties;
        Properties properties2;
        if (propertiesFile == null) {
            properties2 = new Properties();
            if (properties2 == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/PropertiesUtil.loadPropertiesXml must not return null");
            return properties2;
        }
        BufferedInputStream inStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(propertiesFile));
            Properties properties3 = new Properties();
            properties3.loadFromXML(inStream);
            properties = properties3;
        }
        catch (Throwable throwable) {
            PropertiesUtil.close(inStream);
            throw throwable;
        }
        PropertiesUtil.close(inStream);
        properties2 = properties;
        if (properties2 != null) return properties2;
        throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/PropertiesUtil.loadPropertiesXml must not return null");
    }

    @NotNull
    public static Map<String, String> toMap(@NotNull Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/PropertiesUtil.toMap must not be null");
        }
        HashMap<String, String> map = new HashMap<String, String>(properties.size());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
        HashMap<String, String> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/PropertiesUtil.toMap must not return null");
        }
        return hashMap;
    }

    public static void storeProperties(@NotNull Properties properties, @Nullable File propertiesFile, @Nullable String comment) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/PropertiesUtil.storeProperties must not be null");
        }
        if (propertiesFile == null) {
            return;
        }
        PropertiesUtil.storeProperties(properties, new FileOutputStream(propertiesFile), comment);
    }

    public static void storePropertiesZipped(@NotNull Properties properties, @Nullable File propertiesFile, @Nullable String comment) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/PropertiesUtil.storePropertiesZipped must not be null");
        }
        if (propertiesFile == null) {
            return;
        }
        PropertiesUtil.storeProperties(properties, new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(propertiesFile))), comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeProperties(@NotNull Properties properties, @Nullable OutputStream stream, @Nullable String comment) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/PropertiesUtil.storeProperties must not be null");
        }
        if (stream == null) {
            return;
        }
        BufferedOutputStream fos = new BufferedOutputStream(stream);
        try {
            properties.store(fos, comment);
        }
        finally {
            PropertiesUtil.close(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storePropertiesXml(@NotNull Properties properties, @Nullable File propertiesFile, @Nullable String comment) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/PropertiesUtil.storePropertiesXml must not be null");
        }
        if (propertiesFile == null) {
            return;
        }
        BufferedOutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new FileOutputStream(propertiesFile));
            properties.storeToXML((OutputStream)fos, comment, "utf-8");
        }
        catch (Throwable throwable) {
            PropertiesUtil.close(fos);
            throw throwable;
        }
        PropertiesUtil.close(fos);
    }

    public static boolean isDifferent(@NotNull Properties p1, @NotNull Properties p2) {
        if (p1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/PropertiesUtil.isDifferent must not be null");
        }
        if (p2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/PropertiesUtil.isDifferent must not be null");
        }
        return !p1.equals(p2);
    }

    private static byte[] getLineForKey(@NotNull String key, @NotNull String value) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/PropertiesUtil.getLineForKey must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/PropertiesUtil.getLineForKey must not be null");
        }
        Properties ps = new Properties();
        ps.setProperty(key, value);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ps.store(bos, null);
        bos.close();
        List newLines = new LineReader((InputStream)new ByteArrayInputStream(bos.toByteArray())).readLines();
        Iterator iterator = newLines.iterator();
        while (iterator.hasNext()) {
            byte[] line = (byte[])iterator.next();
            if (line.length != 0 && line[0] != 35) continue;
            iterator.remove();
        }
        assert (newLines.size() == 1);
        return (byte[])newLines.get(0);
    }

    public static Set<String> getPropertyNames(@NotNull Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/PropertiesUtil.getPropertyNames must not be null");
        }
        HashSet<String> names = new HashSet<String>();
        Enumeration<?> en = properties.propertyNames();
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            names.add((String)o);
        }
        return names;
    }

    @Nullable
    private static String getKeyFromLine(@NotNull byte[] line) throws IOException {
        if (line == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/PropertiesUtil.getKeyFromLine must not be null");
        }
        Properties ps = new Properties();
        ps.load(new ByteArrayInputStream(line));
        assert (ps.size() <= 1);
        return ps.size() == 0 ? null : (String)ps.keys().nextElement();
    }

    public static boolean updatePropertiesFromFile(@NotNull File propertiesFile, @NotNull Map<String, String> propertiesToUpdate, @NotNull Set<String> toRemove) throws IOException {
        if (propertiesFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/PropertiesUtil.updatePropertiesFromFile must not be null");
        }
        if (propertiesToUpdate == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/PropertiesUtil.updatePropertiesFromFile must not be null");
        }
        if (toRemove == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/PropertiesUtil.updatePropertiesFromFile must not be null");
        }
        if (propertiesToUpdate.isEmpty() && toRemove.isEmpty()) {
            return true;
        }
        Properties properties = PropertiesUtil.loadProperties(propertiesFile);
        for (Map.Entry<String, String> entry : propertiesToUpdate.entrySet()) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
        for (String key : toRemove) {
            properties.remove(key);
        }
        return PropertiesUtil.updateProperties(propertiesFile, properties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateProperties(@NotNull File propertiesFile, @NotNull Properties newProperties, @Nullable String commentIfFileIsRecreated) throws IOException {
        List lines;
        if (propertiesFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/PropertiesUtil.updateProperties must not be null");
        }
        if (newProperties == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/PropertiesUtil.updateProperties must not be null");
        }
        if (!propertiesFile.exists()) {
            PropertiesUtil.storeProperties(newProperties, propertiesFile, commentIfFileIsRecreated);
            return true;
        }
        Properties oldProperties = PropertiesUtil.loadProperties(propertiesFile);
        if (!PropertiesUtil.isDifferent(oldProperties, newProperties)) {
            return false;
        }
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(propertiesFile));
        try {
            lines = new LineReader((InputStream)fis).readLines();
        }
        finally {
            ((InputStream)fis).close();
        }
        Set<String> oldNames = PropertiesUtil.getPropertyNames(oldProperties);
        Set<String> newNames = PropertiesUtil.getPropertyNames(newProperties);
        ArrayList<byte[]> newLines = new ArrayList<byte[]>();
        for (byte[] line : lines) {
            String key = PropertiesUtil.getKeyFromLine(line);
            if (key == null) {
                newLines.add(line);
                continue;
            }
            if (newProperties.containsKey(key)) {
                if (newProperties.getProperty(key).equals(oldProperties.getProperty(key))) {
                    newLines.add(line);
                    continue;
                }
                newLines.add(PropertiesUtil.getLineForKey(key, newProperties.getProperty(key)));
                continue;
            }
            byte[] commented = new byte[line.length + 2];
            commented[0] = 35;
            commented[1] = 32;
            for (byte commented[i + 2] : line) {
            }
            newLines.add(commented);
        }
        for (String newName : newNames) {
            if (oldNames.contains(newName)) continue;
            newLines.add(PropertiesUtil.getLineForKey(newName, newProperties.getProperty(newName)));
        }
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(propertiesFile));
        try {
            byte[] endLine = System.getProperty("line.separator").getBytes("ISO-8859-1");
            for (byte[] newLine : newLines) {
                ((OutputStream)fos).write(newLine);
                ((OutputStream)fos).write(endLine);
            }
        }
        finally {
            PropertiesUtil.close(fos);
        }
        return true;
    }

    private static void close(Closeable cl) {
        if (cl != null) {
            try {
                cl.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

