/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.util.ItemProcessor;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentEntriesCache<K, V> {
    private final Map<K, Value<V>> myEntries;
    private boolean myRememberNullValues = false;
    private final Value<V> myNullValue = new Value(null);

    public RecentEntriesCache(int maxEntries) {
        this(maxEntries, false);
    }

    public RecentEntriesCache(final int maxEntries, boolean rememberNullValues) {
        this.myEntries = new LinkedHashMap<K, Value<V>>(maxEntries, 0.8f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, Value<V>> eldest) {
                return this.size() > maxEntries;
            }
        };
        this.myRememberNullValues = rememberNullValues;
    }

    public synchronized int size() {
        return this.myEntries.size();
    }

    public synchronized boolean isEmpty() {
        return this.myEntries.isEmpty();
    }

    @Nullable
    public synchronized V get(@NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/RecentEntriesCache.get must not be null");
        }
        Value<V> val = this.myEntries.get(key);
        if (val == null) {
            return null;
        }
        return val.get();
    }

    public synchronized void put(@NotNull K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/RecentEntriesCache.put must not be null");
        }
        if (!this.myRememberNullValues && value == null) {
            throw new NullPointerException("Null values are not accepted by this cache");
        }
        this.myEntries.put(key, value == null ? this.myNullValue : new Value(value));
    }

    @NotNull
    public synchronized Set<K> keySet() {
        HashSet<K> hashSet = new HashSet<K>(this.myEntries.keySet());
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/RecentEntriesCache.keySet must not return null");
        }
        return hashSet;
    }

    public synchronized void clear() {
        this.myEntries.clear();
    }

    public synchronized void remove(@NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/RecentEntriesCache.remove must not be null");
        }
        this.myEntries.remove(key);
    }

    public synchronized void removeValues(@NotNull Filter<V> valueFilter) {
        if (valueFilter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/RecentEntriesCache.removeValues must not be null");
        }
        Iterator<Map.Entry<K, Value<V>>> entryIt = this.myEntries.entrySet().iterator();
        while (entryIt.hasNext()) {
            Value<V> value = entryIt.next().getValue();
            if (!valueFilter.accept(value.get())) continue;
            entryIt.remove();
        }
    }

    public synchronized void forEach(@NotNull ItemProcessor<V> processor) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/RecentEntriesCache.forEach must not be null");
        }
        for (Value<V> value : this.myEntries.values()) {
            if (processor.processItem(value.get())) continue;
            return;
        }
    }

    public synchronized V lookupOrCompute(@NotNull K key, @NotNull Function<K, V> compute) {
        V v;
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/RecentEntriesCache.lookupOrCompute must not be null");
        }
        if (compute == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/RecentEntriesCache.lookupOrCompute must not be null");
        }
        Value<V> val = this.myEntries.get(key);
        if (val != null && val == this.myNullValue) {
            return null;
        }
        V v2 = v = val == null ? null : (V)val.get();
        if (v != null) {
            return v;
        }
        v = compute.fun(key);
        if (v == null && this.myRememberNullValues) {
            this.put(key, v);
        } else if (v == null && !this.myRememberNullValues) {
            return null;
        }
        this.put(key, v);
        return v;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Value<V> {
        private final V myValue;

        private Value(V value) {
            this.myValue = value;
        }

        V get() {
            return this.myValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Function<K, V> {
        public V fun(@NotNull K var1);
    }
}

