/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Layout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.LoggingEvent;

public class TCRollingFileAppender
extends RollingFileAppender {
    private FileInfo myFileInfo;
    private volatile boolean myInitialized = false;

    public TCRollingFileAppender() {
    }

    public TCRollingFileAppender(Layout layout, String filename) throws IOException {
        super(layout, filename);
    }

    public TCRollingFileAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, filename, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LoggingEvent event) {
        if (!this.myInitialized) {
            TCRollingFileAppender tCRollingFileAppender = this;
            synchronized (tCRollingFileAppender) {
                if (!this.myInitialized) {
                    try {
                        this.myFileInfo.setFile();
                        this.myInitialized = true;
                    }
                    catch (IOException e) {
                        System.out.println("Cannot call setFile(): " + e.toString());
                    }
                }
            }
        }
        super.append(event);
    }

    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        this.myInitialized = false;
        this.myFileInfo = new FileInfo(fileName, append, bufferedIO, bufferSize);
    }

    private class FileInfo {
        private final String myFileName;
        private final boolean myAppend;
        private final boolean myBufferedIO;
        private final int myBufSize;

        private FileInfo(String fileName, boolean append, boolean bufferedIO, int bufSize) {
            this.myFileName = fileName;
            this.myAppend = append;
            this.myBufferedIO = bufferedIO;
            this.myBufSize = bufSize;
        }

        public void setFile() throws IOException {
            File parent = new File(this.myFileName).getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            TCRollingFileAppender.super.setFile(this.myFileName, this.myAppend, this.myBufferedIO, this.myBufSize);
        }
    }
}

