/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.util.DiagnosticUtil;

public class ThreadUtil {
    public static void shutdownNowAndWait(ExecutorService service, String identifier) {
        assert (service != null);
        service.shutdown();
        try {
            if (service instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor poolExecutor = (ThreadPoolExecutor)service;
                poolExecutor.getQueue().clear();
            }
            service.awaitTermination(5L, TimeUnit.SECONDS);
            if (!service.isTerminated()) {
                Loggers.SERVER.warn("Waiting for " + identifier + " to complete");
            }
            service.shutdownNow();
            service.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Loggers.SERVER.warn((Throwable)e);
        }
        if (!service.isTerminated()) {
            Loggers.SERVER.warn("Stopped waiting for " + identifier + " to complete, some of them are still running");
            DiagnosticUtil.threadDumpToLog(service);
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

