/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

public class TimePrinter {
    private final boolean myAlwaysPrintSeconds;
    private final boolean mySecondsFormatter;

    private TimePrinter(boolean alwaysPrintSeconds, boolean formatTimeAsSeconds) {
        this.myAlwaysPrintSeconds = alwaysPrintSeconds;
        this.mySecondsFormatter = formatTimeAsSeconds;
    }

    public String formatTime(long seconds) {
        StringBuilder sb = new StringBuilder();
        this.formatTime(sb, seconds);
        return sb.toString();
    }

    private long process(StringBuilder sb, long time, int mult, String periodName) {
        long n = time / (long)mult;
        if (n > 0L) {
            if (sb.length() > 0) {
                sb.append(":");
                if (n < 10L) {
                    sb.append("0");
                }
            }
            sb.append(n).append(periodName);
            time -= n * (long)mult;
        } else if ("m".equals(periodName) && sb.length() > 0) {
            sb.append(":0m");
        } else if (!this.mySecondsFormatter && time > 0L && "s".equals(periodName) && sb.length() > 0) {
            sb.append(":0s");
        }
        return time;
    }

    public void formatTime(StringBuilder sb, long timeToFormat) {
        StringBuilder builder = new StringBuilder();
        int multilier = 1;
        if (!this.mySecondsFormatter) {
            multilier = 1000;
        }
        if (timeToFormat < 0L) {
            builder.append("N/A");
        } else if (timeToFormat == 0L) {
            builder.append(this.mySecondsFormatter ? "< 1s" : "< 1ms");
        } else {
            timeToFormat = this.process(builder, timeToFormat, 3600 * multilier, "h");
            timeToFormat = this.process(builder, timeToFormat, 60 * multilier, "m");
            if (this.myAlwaysPrintSeconds || !this.mySecondsFormatter || builder.indexOf("h") < 0) {
                timeToFormat = this.process(builder, timeToFormat, multilier, "s");
            }
            if (!this.mySecondsFormatter) {
                if (timeToFormat > 0L) {
                    if (builder.length() > 0) {
                        builder.append(",");
                        if (timeToFormat < 10L) {
                            builder.append("0");
                        }
                        if (timeToFormat < 100L) {
                            builder.append("0");
                        }
                    }
                    builder.append(timeToFormat).append("ms");
                } else if (builder.length() > 0) {
                    builder.append(",000ms");
                }
            }
        }
        sb.append((CharSequence)builder);
    }

    public static TimePrinter createSecondsFormatter(boolean alwaysPrintSeconds) {
        return new TimePrinter(alwaysPrintSeconds, true);
    }

    public static TimePrinter createMillisecondsFormatter() {
        return new TimePrinter(true, false);
    }
}

