/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharSequenceReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.serverSide.crypt.EncryptUtil;
import jetbrains.buildServer.util.StringUtil;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtil {
    public static final String PARAMETER_ELEMENT_NAME = "param";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDocument(Document document, OutputStream os) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(os, Charset.forName("UTF-8"));
        try {
            Format format = Format.getPrettyFormat();
            format.setLineSeparator(System.getProperty("line.separator"));
            format.setEncoding("UTF-8");
            new XMLOutputter(format).output(document, (Writer)writer);
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    public static boolean isSecureParameter(String parameterName) {
        return parameterName.startsWith("secure:");
    }

    public static Element writeParameter(Element parentElement, String name, String value) {
        boolean multiline;
        String val = value;
        if (XmlUtil.isSecureParameter(name)) {
            val = EncryptUtil.scramble(value);
        }
        Element paramElement = new Element(PARAMETER_ELEMENT_NAME);
        parentElement.addContent((Content)paramElement);
        paramElement.setAttribute("name", name);
        boolean bl = multiline = value.indexOf(10) != -1;
        if (!multiline) {
            paramElement.setAttribute("value", val);
        } else if (value.indexOf("<![CDATA[") != -1) {
            paramElement.addContent(val);
        } else {
            paramElement.addContent((Content)new CDATA(val));
        }
        return paramElement;
    }

    @NotNull
    public static Pair<String, String> readParameter(@NotNull Element paramElement) {
        if (paramElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/XmlUtil.readParameter must not be null");
        }
        String name = paramElement.getAttributeValue("name");
        String value = paramElement.getAttributeValue("value");
        if (value == null) {
            value = paramElement.getTextTrim();
        }
        if (value == null) {
            value = "";
        }
        if (!StringUtil.isEmpty((String)value) && XmlUtil.isSecureParameter(name)) {
            value = EncryptUtil.unscramble(value);
        }
        Pair pair = new Pair((Object)name, (Object)value);
        if (pair == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/XmlUtil.readParameter must not return null");
        }
        return pair;
    }

    public static void writeParameters(Element parentElement, Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            String val = params.get(key);
            XmlUtil.writeParameter(parentElement, key, val);
        }
    }

    @NotNull
    public static Map<String, String> readParameters(@NotNull Element parametersElement) {
        if (parametersElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/XmlUtil.readParameters must not be null");
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        List parametersElements = parametersElement.getChildren(PARAMETER_ELEMENT_NAME);
        for (Object obj : parametersElements) {
            Element parameter = (Element)obj;
            Pair<String, String> param = XmlUtil.readParameter(parameter);
            result.put((String)param.getFirst(), (String)param.getSecond());
        }
        LinkedHashMap<String, String> linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/XmlUtil.readParameters must not return null");
        }
        return linkedHashMap;
    }

    public static String to_s(Element el) {
        return new XMLOutputter(Format.getPrettyFormat()).outputString(el);
    }

    public static Element from_s(String xmlString) {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            saxBuilder.setReuseParser(false);
            saxBuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) {
                    return new InputSource(new CharArrayReader(ArrayUtil.EMPTY_CHAR_ARRAY));
                }
            });
            return saxBuilder.build((Reader)new CharSequenceReader((CharSequence)xmlString)).getRootElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

