/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.fileLookup;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.fileLookup.FileInfo;
import jetbrains.buildServer.util.fileLookup.FileSystemIterator;
import jetbrains.buildServer.util.fileLookup.MemorizingLookup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemorizingFileLookup
extends MemorizingLookup<FileInfo, File, File> {
    @NotNull
    private final File myBaseFolder;

    public MemorizingFileLookup(final @NotNull File baseFolder) {
        if (baseFolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/fileLookup/MemorizingFileLookup.<init> must not be null");
        }
        super(new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new FileSystemIterator(baseFolder, new FileFilter(){

                    public boolean accept(File file) {
                        return file.isDirectory();
                    }
                }, true);
            }
        });
        this.myBaseFolder = baseFolder;
    }

    @Override
    @Nullable
    protected File lookupInside(@NotNull File subfolder, @NotNull FileInfo fileInfo) {
        if (subfolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/fileLookup/MemorizingFileLookup.lookupInside must not be null");
        }
        if (fileInfo == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/fileLookup/MemorizingFileLookup.lookupInside must not be null");
        }
        String path = subfolder.getPath();
        if (!path.endsWith(fileInfo.getParentPath())) {
            return null;
        }
        for (String name : fileInfo.getPossibleFileNames()) {
            File found = new File(new File(this.myBaseFolder, path), name);
            if (!found.isFile()) continue;
            return found;
        }
        return null;
    }

    @NotNull
    public FileInfo createFileInfo(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/fileLookup/MemorizingFileLookup.createFileInfo must not be null");
        }
        FileInfo fileInfo = this.createFileInfo(new File(filePath));
        if (fileInfo == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/fileLookup/MemorizingFileLookup.createFileInfo must not return null");
        }
        return fileInfo;
    }

    @NotNull
    public FileInfo createFileInfo(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/fileLookup/MemorizingFileLookup.createFileInfo must not be null");
        }
        FileInfo fileInfo = this.createFileInfo(file.getParentFile(), file.getName());
        if (fileInfo == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/fileLookup/MemorizingFileLookup.createFileInfo must not return null");
        }
        return fileInfo;
    }

    @NotNull
    public FileInfo createFileInfo(@Nullable File parentFile, @NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/fileLookup/MemorizingFileLookup.createFileInfo must not be null");
        }
        FileInfo fileInfo = this.createFileInfo(parentFile, Arrays.asList(fileName));
        if (fileInfo == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/fileLookup/MemorizingFileLookup.createFileInfo must not return null");
        }
        return fileInfo;
    }

    @NotNull
    public FileInfo createFileInfo(@Nullable File parentFile, final @NotNull Collection<String> possibleFileNames) {
        if (possibleFileNames == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/fileLookup/MemorizingFileLookup.createFileInfo must not be null");
        }
        final String parentPath = parentFile == null || this.myBaseFolder.equals(parentFile) ? "" : (FileUtil.isAncestor(this.myBaseFolder, parentFile, false) ? FileUtil.getRelativePath((File)this.myBaseFolder, (File)parentFile) : parentFile.getPath());
        FileInfo fileInfo = new FileInfo(){

            @Override
            @NotNull
            public String getParentPath() {
                String string = parentPath;
                if (string == null) {
                    throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/fileLookup/MemorizingFileLookup$2.getParentPath must not return null");
                }
                return string;
            }

            @Override
            @NotNull
            public Collection<String> getPossibleFileNames() {
                Collection collection = possibleFileNames;
                if (collection == null) {
                    throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/fileLookup/MemorizingFileLookup$2.getPossibleFileNames must not return null");
                }
                return collection;
            }
        };
        if (fileInfo == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/fileLookup/MemorizingFileLookup.createFileInfo must not return null");
        }
        return fileInfo;
    }
}

