/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.positioning;

import jetbrains.buildServer.util.positioning.PositionConstraint;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PositioningItem<T> {
    private final T myItem;
    private final String myId;
    private final PositionConstraint myConstraint;

    public PositioningItem(@NotNull T item, @NotNull String id, @NotNull PositionConstraint constraint) {
        if (item == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/positioning/PositioningItem.<init> must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/util/positioning/PositioningItem.<init> must not be null");
        }
        if (constraint == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/util/positioning/PositioningItem.<init> must not be null");
        }
        this.myItem = item;
        this.myId = id;
        this.myConstraint = constraint;
    }

    @NotNull
    public T getItem() {
        T t = this.myItem;
        if (t == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/positioning/PositioningItem.getItem must not return null");
        }
        return t;
    }

    @NotNull
    public String getOrderId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/positioning/PositioningItem.getOrderId must not return null");
        }
        return string;
    }

    @NotNull
    public PositionConstraint getConstraint() {
        PositionConstraint positionConstraint = this.myConstraint;
        if (positionConstraint == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/positioning/PositioningItem.getConstraint must not return null");
        }
        return positionConstraint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.myItem == ((PositioningItem)o).myItem;
    }

    public int hashCode() {
        return System.identityHashCode(this.myItem);
    }

    @NotNull
    public PositioningItem<T> updatePosition(@NotNull PositionConstraint constraint) {
        if (constraint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/positioning/PositioningItem.updatePosition must not be null");
        }
        PositioningItem<T> positioningItem = new PositioningItem<T>(this.myItem, this.myId, constraint);
        if (positioningItem == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/positioning/PositioningItem.updatePosition must not return null");
        }
        return positioningItem;
    }
}

