/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.Collection;
import java.util.List;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.Converter;
import jetbrains.buildServer.vcs.VcsChangeInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VcsChange
implements VcsChangeInfo {
    private final String myChangeTypeName;
    private final String myFileName;
    private final String myRelativeFileName;
    private final VcsChangeInfo.Type myType;
    private final String myBeforeChangeRevisionNumber;
    private final String myAfterChangeRevisionNumber;

    public VcsChange(@NotNull VcsChangeInfo.Type type, @Nullable String changeName, @NotNull String fileName, @NotNull String relativeFileName, String beforeNum, String afterNum) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/VcsChange.<init> must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/vcs/VcsChange.<init> must not be null");
        }
        if (relativeFileName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of jetbrains/buildServer/vcs/VcsChange.<init> must not be null");
        }
        this.myChangeTypeName = changeName == null ? type.getDescription() : changeName;
        this.myFileName = fileName;
        this.myRelativeFileName = relativeFileName;
        this.myType = type;
        this.myBeforeChangeRevisionNumber = beforeNum;
        this.myAfterChangeRevisionNumber = afterNum;
    }

    public VcsChange(@NotNull VcsChangeInfo.Type type, @NotNull String fileName, @NotNull String relativeFileName, String beforeNum, String afterNum) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/VcsChange.<init> must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/vcs/VcsChange.<init> must not be null");
        }
        if (relativeFileName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of jetbrains/buildServer/vcs/VcsChange.<init> must not be null");
        }
        this.myChangeTypeName = type.getDescription();
        this.myFileName = fileName;
        this.myRelativeFileName = relativeFileName;
        this.myType = type;
        this.myBeforeChangeRevisionNumber = beforeNum;
        this.myAfterChangeRevisionNumber = afterNum;
    }

    protected VcsChange(@NotNull VcsChangeInfo source) {
        if (source == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/VcsChange.<init> must not be null");
        }
        this.myChangeTypeName = source.getChangeTypeName();
        this.myFileName = source.getFileName();
        this.myRelativeFileName = source.getRelativeFileName();
        this.myType = source.getType();
        this.myBeforeChangeRevisionNumber = source.getBeforeChangeRevisionNumber();
        this.myAfterChangeRevisionNumber = source.getAfterChangeRevisionNumber();
    }

    public static List<VcsChange> createList(@Nullable Collection<? extends VcsChangeInfo> source) {
        return CollectionsUtil.convertCollection(source, new Converter<VcsChange, VcsChangeInfo>(){

            @Override
            public VcsChange createFrom(@NotNull VcsChangeInfo source) {
                if (source == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/VcsChange$1.createFrom must not be null");
                }
                return new VcsChange(source);
            }
        });
    }

    public static VcsChange forTest() {
        return new VcsChange(VcsChangeInfo.Type.CHANGED, "changed", "svn:/path/file.txt", "path/file.txt", "1", "2");
    }

    @Override
    @Nullable
    public String getChangeTypeName() {
        return this.myChangeTypeName;
    }

    @Override
    @NotNull
    public String getFileName() {
        String string = this.myFileName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/VcsChange.getFileName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String getRelativeFileName() {
        String string = this.myRelativeFileName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/VcsChange.getRelativeFileName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public VcsChangeInfo.Type getType() {
        VcsChangeInfo.Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/VcsChange.getType must not return null");
        }
        return type;
    }

    @Override
    public String getBeforeChangeRevisionNumber() {
        return this.myBeforeChangeRevisionNumber;
    }

    @Override
    public String getAfterChangeRevisionNumber() {
        return this.myAfterChangeRevisionNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsChange vcsChange = (VcsChange)o;
        if (this.myAfterChangeRevisionNumber != null ? !this.myAfterChangeRevisionNumber.equals(vcsChange.myAfterChangeRevisionNumber) : vcsChange.myAfterChangeRevisionNumber != null) {
            return false;
        }
        if (this.myBeforeChangeRevisionNumber != null ? !this.myBeforeChangeRevisionNumber.equals(vcsChange.myBeforeChangeRevisionNumber) : vcsChange.myBeforeChangeRevisionNumber != null) {
            return false;
        }
        if (!this.myChangeTypeName.equals(vcsChange.myChangeTypeName)) {
            return false;
        }
        if (!this.myFileName.equals(vcsChange.myFileName)) {
            return false;
        }
        if (!this.myRelativeFileName.equals(vcsChange.myRelativeFileName)) {
            return false;
        }
        return this.myType == vcsChange.myType;
    }

    public int hashCode() {
        int result = this.myChangeTypeName != null ? this.myChangeTypeName.hashCode() : 0;
        result = 31 * result + (this.myFileName != null ? this.myFileName.hashCode() : 0);
        result = 31 * result + (this.myRelativeFileName != null ? this.myRelativeFileName.hashCode() : 0);
        result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
        result = 31 * result + (this.myBeforeChangeRevisionNumber != null ? this.myBeforeChangeRevisionNumber.hashCode() : 0);
        result = 31 * result + (this.myAfterChangeRevisionNumber != null ? this.myAfterChangeRevisionNumber.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "VcsChange{myChangeTypeName='" + this.myChangeTypeName + '\'' + ", myFileName='" + this.myFileName + '\'' + ", myRelativeFileName='" + this.myRelativeFileName + '\'' + ", myBeforeChangeRevisionNumber='" + this.myBeforeChangeRevisionNumber + '\'' + ", myAfterChangeRevisionNumber='" + this.myAfterChangeRevisionNumber + '\'' + '}';
    }
}

