/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import jetbrains.buildServer.vcs.CheckoutRules;
import jetbrains.buildServer.vcs.VcsRoot;
import org.jetbrains.annotations.NotNull;

public class VcsRootEntry {
    private final VcsRoot myVcsRoot;
    private final CheckoutRules myCheckoutRules;

    public VcsRootEntry(@NotNull VcsRoot vcsRoot, @NotNull CheckoutRules checkoutRules) {
        if (vcsRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/VcsRootEntry.<init> must not be null");
        }
        if (checkoutRules == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/vcs/VcsRootEntry.<init> must not be null");
        }
        this.myVcsRoot = vcsRoot;
        this.myCheckoutRules = checkoutRules;
    }

    @NotNull
    public VcsRoot getVcsRoot() {
        VcsRoot vcsRoot = this.myVcsRoot;
        if (vcsRoot == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/VcsRootEntry.getVcsRoot must not return null");
        }
        return vcsRoot;
    }

    @NotNull
    public CheckoutRules getCheckoutRules() {
        CheckoutRules checkoutRules = this.myCheckoutRules;
        if (checkoutRules == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/VcsRootEntry.getCheckoutRules must not return null");
        }
        return checkoutRules;
    }

    @NotNull
    public String getSignature() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getVcsRoot().getId());
        builder.append('_');
        builder.append(this.getVcsRoot().getVcsName());
        builder.append('_');
        builder.append(this.getVcsRoot().getPropertiesHash());
        builder.append('_');
        builder.append(this.getCheckoutRules().hashCode());
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/vcs/VcsRootEntry.getSignature must not return null");
        }
        return string;
    }

    public String toString() {
        return "VcsRootEntry[myVcsRoot=" + this.myVcsRoot + ", myCheckoutRules=" + this.myCheckoutRules + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsRootEntry that = (VcsRootEntry)o;
        if (this.myCheckoutRules != null ? !this.myCheckoutRules.equals(that.myCheckoutRules) : that.myCheckoutRules != null) {
            return false;
        }
        return this.myVcsRoot.getId() == that.myVcsRoot.getId();
    }

    public int hashCode() {
        int result = (int)this.myVcsRoot.getId();
        result = 31 * result + (this.myCheckoutRules != null ? this.myCheckoutRules.hashCode() : 0);
        return result;
    }
}

