/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import jetbrains.buildServer.serverSide.crypt.EncryptUtil;
import jetbrains.buildServer.util.Hash;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.vcs.VcsRoot;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VcsRootImpl
implements VcsRoot {
    protected String myVcsName;
    protected final Map<String, String> myProperties = new HashMap<String, String>();
    @NonNls
    public static final String VCS_NAME_PROP = "vcs";
    @NonNls
    public static final String VCS_ROOT_NAME_PROP = "teamcity:vcsRootName";
    @NonNls
    public static final String BRANCH_SPEC_PROP = "teamcity:branchSpec";
    @NonNls
    protected static final String CHECKOUT_ROOT = "checkout-root";
    private final long myId;
    private String myName;
    private String myBranchSpec;

    public VcsRootImpl(long id, Map<String, String> properties) {
        this.myId = id;
        this.myVcsName = properties.get(VCS_NAME_PROP);
        if (this.myVcsName == null) {
            this.myVcsName = "unknown";
        }
        this.myName = properties.get(VCS_ROOT_NAME_PROP);
        if (this.myName == null) {
            this.myName = "unknown";
        }
        this.myBranchSpec = properties.get(BRANCH_SPEC_PROP);
        if (this.myBranchSpec == null) {
            this.myBranchSpec = "";
        }
        HashMap<String, String> propsCopy = new HashMap<String, String>(properties);
        propsCopy.remove(CHECKOUT_ROOT);
        propsCopy.remove(VCS_ROOT_NAME_PROP);
        propsCopy.remove(VCS_NAME_PROP);
        this.addAllProperties(propsCopy);
    }

    public VcsRootImpl(long id, String vcsName) {
        this.myVcsName = vcsName;
        this.myId = id;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public String getSimplifiedName() {
        return StringUtil.replaceNonAlphaNumericChars(this.getName(), '_');
    }

    @Override
    public long getId() {
        return this.myId;
    }

    @Override
    public Map<String, String> getPublicProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> prop : this.myProperties.entrySet()) {
            String propName = prop.getKey();
            String propValue = prop.getValue();
            if (VcsRootImpl.isSecureProperty(propName)) continue;
            result.put(propName, propValue);
        }
        return result;
    }

    public void addProperty(String propertyName, String propertyValue) {
        this.myProperties.put(propertyName, propertyValue);
    }

    public void addAllProperties(@NotNull Map<String, String> map) {
        if (map == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/impl/VcsRootImpl.addAllProperties must not be null");
        }
        this.myProperties.putAll(map);
    }

    @Override
    public String getVcsName() {
        return this.myVcsName;
    }

    @Override
    public String getProperty(String propertyName) {
        return this.myProperties.get(propertyName);
    }

    @Override
    public String getProperty(String propertyName, String defaultValue) {
        String result = this.getProperty(propertyName);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.myProperties);
    }

    @Override
    public String convertToString() {
        return VcsRootImpl.propertiesToString(this.createMap());
    }

    @Override
    public String convertToPresentableString() {
        return VcsRootImpl.propertiesToPresentableString(this.createMap());
    }

    @Override
    public long getPropertiesHash() {
        HashMap<String, String> propsCopy = new HashMap<String, String>(this.getProperties());
        propsCopy.remove(VCS_NAME_PROP);
        propsCopy.remove(VCS_ROOT_NAME_PROP);
        propsCopy.remove(BRANCH_SPEC_PROP);
        return Hash.calc(VcsRootImpl.propertiesToString(propsCopy, false));
    }

    public static String propertiesToString(Map<String, String> properties) {
        return VcsRootImpl.propertiesToString(properties, true);
    }

    public static String propertiesToString(Map<String, String> properties, boolean scrambleSecureProps) {
        ArrayList<String> keys = new ArrayList<String>(properties.keySet());
        Collections.sort(keys);
        StringBuilder builder = new StringBuilder();
        for (String key : keys) {
            builder.append(VcsRootImpl.escapeStr(key));
            builder.append('=');
            String value = properties.get(key);
            if (scrambleSecureProps && VcsRootImpl.isSecureProperty(key)) {
                value = EncryptUtil.scramble(value);
            }
            builder.append(VcsRootImpl.escapeStr(value));
            builder.append('\n');
        }
        return builder.toString();
    }

    private static String escapeStr(String str) {
        if (str == null) {
            return null;
        }
        int finalCount = VcsRootImpl.calcFinalEscapedStringCount(str);
        if (str.length() == finalCount) {
            return str;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\n') {
                resultChars[resultPos++] = 92;
                resultChars[resultPos++] = 45;
                continue;
            }
            if (c == '\\') {
                resultChars[resultPos++] = 92;
                resultChars[resultPos++] = 92;
                continue;
            }
            if (c == '=') {
                resultChars[resultPos++] = 92;
                resultChars[resultPos++] = 95;
                continue;
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect escaping for '" + str + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalEscapedStringCount(String name) {
        int result = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '\n') {
                result += 2;
                continue;
            }
            if (c == '\\') {
                result += 2;
                continue;
            }
            if (c == '=') {
                result += 2;
                continue;
            }
            ++result;
        }
        return result;
    }

    public static String unescapeStr(String name) {
        if (name == null) {
            return null;
        }
        int finalCount = VcsRootImpl.calcFinalUnescapedStringCount(name);
        int len = name.length();
        if (len == finalCount) {
            return name;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i = 0; i < len; ++i) {
            int c = name.charAt(i);
            if (c == 92 && i < len - 1) {
                char nextChar = name.charAt(i + 1);
                if (nextChar == '-') {
                    c = 10;
                    ++i;
                } else if (nextChar == '\\') {
                    c = 92;
                    ++i;
                } else if (nextChar == '_') {
                    c = 61;
                    ++i;
                }
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect unescaping for '" + name + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalUnescapedStringCount(String name) {
        int result = 0;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char nextChar;
            char c = name.charAt(i);
            if (c == '\\' && i < len - 1 && ((nextChar = name.charAt(i + 1)) == '-' || nextChar == '_' || nextChar == '\\')) {
                ++i;
            }
            ++result;
        }
        return result;
    }

    private static String propertiesToPresentableString(Map<String, String> properties) {
        ArrayList<String> keys = new ArrayList<String>(properties.keySet());
        Collections.sort(keys);
        StringBuilder builder = new StringBuilder();
        for (String key : keys) {
            builder.append(key);
            builder.append('=');
            if (VcsRootImpl.isSecureProperty(key)) {
                builder.append("*****");
            } else {
                builder.append(properties.get(key));
            }
            builder.append("; ");
        }
        return builder.toString();
    }

    public static boolean isSecureProperty(String propertyName) {
        return propertyName.startsWith("secure:");
    }

    public static Map<String, String> stringToProperties(String string) {
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(string, "\n", false);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            int sepIndex = s.indexOf(61);
            if (sepIndex < 0) continue;
            String propName = VcsRootImpl.unescapeStr(s.substring(0, sepIndex));
            String propValue = VcsRootImpl.unescapeStr(s.substring(sepIndex + 1));
            if (VcsRootImpl.isSecureProperty(propName)) {
                try {
                    propValue = EncryptUtil.unscramble(propValue);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            result.put(propName, propValue);
        }
        return result;
    }

    public Map<String, String> createMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(VCS_NAME_PROP, this.myVcsName);
        result.put(VCS_ROOT_NAME_PROP, this.myName);
        result.put(BRANCH_SPEC_PROP, this.myBranchSpec);
        result.putAll(this.myProperties);
        return result;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/vcs/impl/VcsRootImpl.setName must not be null");
        }
        this.myName = name;
    }

    public static boolean isEquivalentRoots(VcsRoot root1, VcsRoot root2) {
        if (!root1.getVcsName().equals(root2.getVcsName())) {
            return false;
        }
        return ((Object)root1.getProperties()).equals(root2.getProperties());
    }

    public String toString() {
        return this.getName() + " {id=" + this.getId() + "}";
    }
}

