/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.xstream;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import jetbrains.buildServer.messages.XStreamHolder;
import jetbrains.buildServer.util.Alarm;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.xstream.XStreamWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XStreamFile<T>
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)XStreamFile.class.getName());
    private transient Alarm mySaveDataTimer;
    private final File myFile;
    private T mySavingNow;
    private final XStreamHolder myXStreamHolder;

    public XStreamFile(File file, XStreamHolder holder) {
        this.myFile = file;
        this.myXStreamHolder = holder;
    }

    public void dispose() {
        if (this.mySaveDataTimer != null) {
            this.mySaveDataTimer.dispose();
        }
    }

    public synchronized void serialize(final T o, boolean now) {
        if (now) {
            this.saveNow(o);
        } else if (this.mySavingNow != o) {
            this.mySavingNow = o;
            if (this.mySaveDataTimer == null) {
                this.mySaveDataTimer = new Alarm("Save " + this.myFile.getName() + " timer");
            }
            this.mySaveDataTimer.cancelAllRequests();
            this.mySaveDataTimer.addRequest(new Runnable(){

                public void run() {
                    XStreamFile.this.serialize(o, true);
                }
            }, 500L, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveNow(T o) {
        block9: {
            String s = XStreamWrapper.serializeObject(o, this.myXStreamHolder);
            try {
                this.mySavingNow = o;
                FileWriter writer = null;
                try {
                    writer = new FileWriter(this.myFile);
                    writer.write(s);
                }
                catch (InterruptedIOException e) {
                    LOG.warn("Attempt to write data to file " + this.myFile.getAbsolutePath() + " was interrupted");
                    FileUtil.close(writer);
                    break block9;
                }
                catch (IOException e2) {
                    LOG.error("Failed to write data to file " + this.myFile.getAbsolutePath(), (Throwable)e2);
                    {
                        catch (Throwable throwable) {
                            FileUtil.close(writer);
                            throw throwable;
                        }
                    }
                    FileUtil.close(writer);
                    break block9;
                }
                FileUtil.close(writer);
            }
            finally {
                this.mySavingNow = null;
            }
        }
    }

    public synchronized T deserialize() {
        if (this.myFile.exists()) {
            try {
                return XStreamWrapper.deserializeObject(new String(FileUtil.loadFileText((File)this.myFile)), this.myXStreamHolder);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        return null;
    }

    public File getPath() {
        return this.myFile.getParentFile();
    }
}

