/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.lang.reflect.Field;
import java.util.TimeZone;
import org.apache.xmlrpc.TCTypeFactory;
import org.apache.xmlrpc.TCXmlRpcClientRequestProcessor;
import org.apache.xmlrpc.TCXmlRpcResponseProcessor;
import org.apache.xmlrpc.TypeFactory;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClientRequestProcessor;
import org.apache.xmlrpc.XmlRpcClientResponseProcessor;
import org.apache.xmlrpc.XmlRpcRequestProcessor;
import org.apache.xmlrpc.XmlRpcResponseProcessor;

public class TCProcessorFactory {
    public static final String XMLRPC_TYPE_FACTORY = TypeFactory.class.getName();

    public static XmlRpcClientRequestProcessor createClientRequestProcessor(TimeZone tz) {
        return new TCXmlRpcClientRequestProcessor(tz);
    }

    public static XmlRpcResponseProcessor createResponseProcessor() {
        return new TCXmlRpcResponseProcessor();
    }

    public static synchronized XmlRpcRequestProcessor createRequestProcessor() {
        XmlRpcRequestProcessor processor = new XmlRpcRequestProcessor();
        try {
            TCProcessorFactory.setTypeFactory((XmlRpc)processor);
        }
        catch (Exception e) {
            TCProcessorFactory.logFailedToSetFactory(e);
            processor = TCProcessorFactory.createRequestProcessorWithFectory();
        }
        return processor;
    }

    private static void logFailedToSetFactory(Exception e) {
        System.err.println("Failed to set TCTypeFactory via reflection: " + e + ", will use system property");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XmlRpcRequestProcessor createRequestProcessorWithFectory() {
        String oldFactory = TCProcessorFactory.setNewFactory();
        try {
            XmlRpcRequestProcessor xmlRpcRequestProcessor = new XmlRpcRequestProcessor();
            return xmlRpcRequestProcessor;
        }
        finally {
            TCProcessorFactory.restoreOldFactory(oldFactory);
        }
    }

    public static synchronized XmlRpcClientResponseProcessor createClientResponseProcessor(TimeZone timeZone) {
        XmlRpcClientResponseProcessor processor = new XmlRpcClientResponseProcessor(timeZone);
        try {
            TCProcessorFactory.setTypeFactory((XmlRpc)processor);
        }
        catch (Exception e) {
            TCProcessorFactory.logFailedToSetFactory(e);
            processor = TCProcessorFactory.createClientResponseProcessorWithFactory(timeZone);
        }
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XmlRpcClientResponseProcessor createClientResponseProcessorWithFactory(TimeZone timeZone) {
        String oldFactory = TCProcessorFactory.setNewFactory();
        try {
            XmlRpcClientResponseProcessor xmlRpcClientResponseProcessor = new XmlRpcClientResponseProcessor(timeZone);
            return xmlRpcClientResponseProcessor;
        }
        finally {
            TCProcessorFactory.restoreOldFactory(oldFactory);
        }
    }

    private static String setNewFactory() {
        return System.setProperty(XMLRPC_TYPE_FACTORY, "org.apache.xmlrpc.TCTypeFactory");
    }

    private static void restoreOldFactory(String oldFactoryClass) {
        if (oldFactoryClass == null) {
            System.getProperties().remove(XMLRPC_TYPE_FACTORY);
        } else {
            System.setProperty(XMLRPC_TYPE_FACTORY, oldFactoryClass);
        }
    }

    private static void setTypeFactory(XmlRpc xmlRpc) throws NoSuchFieldException, IllegalAccessException {
        Field field = XmlRpc.class.getDeclaredField("typeFactory");
        field.setAccessible(true);
        field.set(xmlRpc, (Object)new TCTypeFactory());
    }
}

