/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.IOException;
import java.net.URL;
import java.util.EmptyStackException;
import java.util.TimeZone;
import org.apache.xmlrpc.TCDefaultXmlRpcTransport;
import org.apache.xmlrpc.TCProcessorFactory;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcClientException;
import org.apache.xmlrpc.XmlRpcClientRequest;
import org.apache.xmlrpc.XmlRpcClientRequestProcessor;
import org.apache.xmlrpc.XmlRpcClientResponseProcessor;
import org.apache.xmlrpc.XmlRpcClientWorker;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcTransport;

public class TCXmlRpcClient
extends XmlRpcClient {
    private final String myUserAgent;
    private final int myTimeout;

    public TCXmlRpcClient(URL url, String userAgent, int timeout) {
        super(url);
        this.myUserAgent = userAgent;
        this.myTimeout = timeout;
    }

    protected XmlRpcTransport createTransport() throws XmlRpcClientException {
        TCDefaultXmlRpcTransport transport = new TCDefaultXmlRpcTransport(this.url, this.myUserAgent);
        transport.setTimeout(this.myTimeout);
        return transport;
    }

    synchronized XmlRpcClientWorker getWorker(boolean async) throws IOException {
        try {
            XmlRpcClientWorker w = (XmlRpcClientWorker)this.pool.pop();
            if (async) {
                ++this.asyncWorkers;
            } else {
                ++this.workers;
            }
            return w;
        }
        catch (EmptyStackException x) {
            if (this.workers < this.getMaxThreads()) {
                if (async) {
                    ++this.asyncWorkers;
                } else {
                    ++this.workers;
                }
                return this.createWorker();
            }
            throw new IOException("XML-RPC System overload");
        }
    }

    private XmlRpcClientWorker createWorker() {
        final TimeZone tz = this.getTimeZone();
        XmlRpcClientRequestProcessor reqProcessor = TCProcessorFactory.createClientRequestProcessor(tz);
        XmlRpcClientResponseProcessor respProcessor = this.createResponseProcessor(tz);
        return new XmlRpcClientWorker(reqProcessor, respProcessor){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object execute(XmlRpcClientRequest xmlRpcRequest, XmlRpcTransport transport) throws XmlRpcException, IOException {
                try {
                    Object object = super.execute(xmlRpcRequest, transport);
                    return object;
                }
                finally {
                    this.responseProcessor = TCXmlRpcClient.this.createResponseProcessor(tz);
                }
            }
        };
    }

    private XmlRpcClientResponseProcessor createResponseProcessor(TimeZone tz) {
        return TCProcessorFactory.createClientResponseProcessor(tz);
    }
}

