package com.turn.ttorrent.common;

import java.net.InetSocketAddress;

/* 保存用户的地址相关信息
* 标识唯一一个用户和用户相关的torrent地址
* */
public class PeerUID {

  private final InetSocketAddress myAddress;// 保存ip地址，端口号，主机名
  private final String myTorrentHash;// 标识唯一的torrent文件

  public PeerUID(InetSocketAddress address, String torrentHash) {
    myAddress = address;
    myTorrentHash = torrentHash;
  }

  public String getTorrentHash() {
    return myTorrentHash;
  }

  public InetSocketAddress getAddress() {
    return myAddress;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    PeerUID peerUID = (PeerUID) o;

    if (!myAddress.equals(peerUID.myAddress)) return false;
    return myTorrentHash.equals(peerUID.myTorrentHash);
  }

  @Override
  public int hashCode() {
    int result = myAddress.hashCode();
    result = 31 * result + myTorrentHash.hashCode();
    return result;
  }

  @Override
  public String toString() {
    return "PeerUID{" +
            "address=" + myAddress +
            ", torrent hash='" + myTorrentHash + '\'' +
            '}';
  }
}
