package com.ptp.ptplatform.config;

import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebMvcConfig implements WebMvcConfigurer {

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        // 获取项目运行目录的绝对路径
        String projectPath = System.getProperty("user.dir");
        // 定义本地文件存储路径（与代码中上传路径一致）
        String uploadPath = projectPath + "/uploads/";

        // 关键配置：将URL路径 "/uploads/**" 映射到本地文件系统
        registry.addResourceHandler("/uploads/**")
                .addResourceLocations("file:" + uploadPath);
    }
}