package com.ptp.ptplatform.controller;

import com.ptp.ptplatform.entity.ANNOUNCEMENT;
import com.ptp.ptplatform.mapper.AnnouncementMapper;
import com.ptp.ptplatform.utils.Result;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.List;

@RestController
@RequestMapping("/announcement")
public class AnnouncementController {

    private final AnnouncementMapper announcementMapper;

    public AnnouncementController(AnnouncementMapper announcementMapper) {
        this.announcementMapper = announcementMapper;
    }

    // 获取所有公告
    @GetMapping("/list")
    public Result listAll() {
        List<ANNOUNCEMENT> announcements = announcementMapper.selectAll();
        return Result.ok().data("announcements", announcements);
    }

    // 获取最新5条公告（用于首页展示）
    @GetMapping("/latest")
    public Result listLatest() {
        List<ANNOUNCEMENT> announcements = announcementMapper.selectLatest(5);
        return Result.ok().data("announcements", announcements);
    }

    // 获取公告详情
    @GetMapping("/{id}")
    public Result getDetail(@PathVariable Integer id) {
        ANNOUNCEMENT announcement = announcementMapper.selectById(id);
        if (announcement == null) {
            return Result.error(404).message("公告不存在");
        }
        return Result.ok().data("announcement", announcement);
    }

    // 新增公告
    @PostMapping("/create")
    public Result createAnnouncement(@RequestParam String title, @RequestParam String content) {
        try {
            ANNOUNCEMENT announcement = new ANNOUNCEMENT();
            announcement.setTitle(title);
            announcement.setContent(content);
            announcement.setCreateTime(LocalDateTime.now());

            int result = announcementMapper.insert(announcement);
            if (result > 0) {
                return Result.ok().message("公告发布成功");
            } else {
                // 添加错误码参数（如500表示服务器错误）
                return Result.error(500).message("公告发布失败");
            }
        } catch (Exception e) {
            // 添加错误码参数（如500表示服务器错误）
            return Result.error(500).message("服务器错误: " + e.getMessage());
        }
    }
}

