package com.ptp.ptplatform.controller;

import com.ptp.ptplatform.entity.DISCOUNT;
import com.ptp.ptplatform.mapper.DiscountMapper;
import com.ptp.ptplatform.utils.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.List;

@RestController
@RequestMapping("/discount")
public class DiscountController {

    @Autowired
    private DiscountMapper discountMapper;
    @Autowired
    private DataSourcePoolMetadataProvider dataSourcePoolMetadataProvider;

    // 增加新折扣
    @PostMapping("/add")
    public Result addDiscount(@RequestBody DISCOUNT discount) {
        // 获取当前时间
        LocalDateTime now = LocalDateTime.now();
        discount.setCreateTime(now);
        System.out.println("now" + now);

        // 检查折扣开始时间是否早于当前时间
        if (discount.getStartTime().isBefore(now)) {
            return Result.error(400).setMessage("折扣开始时间最早不能早于现在。");
        }

        // 检查折扣开始时间是否早于结束时间
        if (discount.getStartTime().isAfter(discount.getEndTime())) {
            return Result.error(400).setMessage("折扣开始时间必须早于结束时间。");
        }

        // 检查时间是否重叠
        int overlapCount = discountMapper.checkOverlapTime(discount.getStartTime(), discount.getEndTime());
        if (overlapCount > 0) {
            return Result.error(400).setMessage("新折扣时间与已有折扣时间重叠，请选择不同时间。");
        }

        // 新增折扣
        int result = discountMapper.insertDiscount(discount);
        if (result > 0) {
            return Result.ok().data("data", discount);
        } else {
            return Result.error(500).setMessage("添加折扣失败。");
        }
    }

    // 删除折扣
    @DeleteMapping("/delete/{id}")
    public Result deleteDiscount(@PathVariable int id) {
        int result = discountMapper.deleteDiscountById(id);
        if (result > 0) {
            return Result.ok().setMessage("删除成功。");
        } else {
            return Result.error(404).setMessage("折扣未找到。");
        }
    }

    // 查询当前进行中的折扣
    @GetMapping("/current")
    public Result getCurrentDiscount() {
        DISCOUNT discount = discountMapper.selectCurrentDiscount();
        if (discount != null) {
            return Result.ok().data("data", discount);
        } else {
            return Result.ok().setMessage("目前没有进行中的折扣。");
        }
    }

    // 查询所有折扣计划
    @GetMapping("/all")
    public Result getAllDiscounts() {
        List<DISCOUNT> discounts = discountMapper.selectAllDiscounts();
        return Result.ok().data("data", discounts);
    }
}