package com.ptp.ptplatform.controller;


import com.ptp.ptplatform.entity.INVITE_CODE;
import com.ptp.ptplatform.entity.USER;
import com.ptp.ptplatform.mapper.InviteCodeMapper;
import com.ptp.ptplatform.mapper.UserMapper;
import com.ptp.ptplatform.utils.Result;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/invitecode")
public class InviteCodeController {
    //mapper和controller
    @Resource
    private InviteCodeMapper inviteCodeMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserController userController;

    //使用魔力值兑换邀请码
    @PostMapping("/generate")
    public Result generateInviteCode(HttpServletRequest request) {
        USER user = userController.getUserInRequest(request);
        System.out.println(user.getMagicPoints());
        if (user.getMagicPoints() >= 10) {
            user.generateInviteCode();
            INVITE_CODE inviteCode = new INVITE_CODE(user.getUsername());

            inviteCodeMapper.insertInviteCode(inviteCode);
            userMapper.updateUser(user);

            return Result.ok().data("inviteCode", inviteCode);

        } else {
            return Result.error(404).setMessage("兑换邀请码失败，魔力值不足。");
        }

    }

    //用户获取持有的邀请码
    @GetMapping("/userInviteCode")
    public Result userInviteCode(HttpServletRequest request) {
        USER user = userController.getUserInRequest(request);

        List<INVITE_CODE> inviteCode = inviteCodeMapper.selectByUser(user.getUsername());
        return Result.ok().data("inviteCode", inviteCode);
    }

}
