package com.ptp.ptplatform.controller;

import com.ptp.ptplatform.entity.Notification;
import com.ptp.ptplatform.service.NotificationService;
import com.ptp.ptplatform.utils.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/notifications")
public class NotificationController {

    @Autowired
    private NotificationService notificationService;

    @GetMapping("")
    public Result listNotifications(@RequestParam("userId") String userId) {
        List<Notification> list = notificationService.listByUser(userId);
        return Result.ok().data("notifications", list);
    }

    @PostMapping("/{id}/read")
    public Result markAsRead(@PathVariable("id") Integer id) {
        try {
            Notification updatedNotification = notificationService.markAsRead(id);
            return Result.ok()
                    .message("通知已标记为已读")
                    .data("notification", updatedNotification);
        } catch (RuntimeException e) {
            return Result.error(500).message(e.getMessage());
        }
    }
}
