package com.ptp.ptplatform.controller;

import com.ptp.ptplatform.entity.TORRENT;
import com.ptp.ptplatform.entity.USER;
import com.ptp.ptplatform.service.RecommenderService;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/recommend")
public class RecommendController {
    @Resource
    private UserController userController;

    private final RecommenderService recommenderService;

    @Autowired
    public RecommendController(RecommenderService recommenderService) {
        this.recommenderService = recommenderService;
    }

    @GetMapping("/for-user")
    public ResponseEntity<List<TORRENT>> recommendForUser(
            HttpServletRequest request,
            @RequestParam(defaultValue = "10") int limit) {
        USER user = userController.getUserInRequest(request);
        if (user == null) {
            return ResponseEntity.status(HttpStatus.UNAUTHORIZED).build();
        }
        return ResponseEntity.ok(recommenderService.recommendForUser(user.getUsername(), limit));
    }

    @PostMapping("/mark-shown/{torrentId}")
    public ResponseEntity<Void> markRecommendationShown(
            HttpServletRequest request,
            @PathVariable Integer torrentId) {
        USER user = userController.getUserInRequest(request);
        if (user == null) {
            return ResponseEntity.status(HttpStatus.UNAUTHORIZED).build();
        }
        recommenderService.markRecommendationAsShown(user.getUsername(), torrentId);
        return ResponseEntity.ok().build();
    }

    @PostMapping("/mark-clicked/{torrentId}")
    public ResponseEntity<Void> markRecommendationClicked(
            HttpServletRequest request,
            @PathVariable Integer torrentId) {
        USER user = userController.getUserInRequest(request);
        if (user == null) {
            return ResponseEntity.status(HttpStatus.UNAUTHORIZED).build();
        }
        recommenderService.markRecommendationAsClicked(user.getUsername(), torrentId);
        return ResponseEntity.ok().build();
    }
}