package com.ptp.ptplatform.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ptp.ptplatform.entity.TorrentComment;
import com.ptp.ptplatform.service.TorrentCommentService;
import com.ptp.ptplatform.utils.Result;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.List;

@RestController
@RequestMapping("/torrent/comments")
@AllArgsConstructor
public class TorrentCommentController {
    private final TorrentCommentService commentService;

    @PostMapping("/{commentId}/like")
    public Result like(@PathVariable int commentId) {
        commentService.incrementLike(commentId);
        return Result.ok();
    }

    // 获取评论的回复
    @GetMapping("/{commentId}/replies")
    public Result getReplies(@PathVariable int commentId) {
        List<TorrentComment> replies = commentService.getReplies(commentId);
        return Result.ok().data("replies", replies);
    }

    @PostMapping("/{commentId}/replies")
    public Result addReply(@PathVariable int commentId,
                           @RequestBody TorrentComment reply) {
        TorrentComment parentComment = commentService.getById(commentId);
        if (parentComment == null) {
            return Result.error(404).setMessage("被回复的评论不存在");
        }

        // 设置完整字段
        reply.setPostId(parentComment.getPostId());
        reply.setParentId(commentId);
        reply.setAuthorId(reply.getAuthorId());
        reply.setReplyTo(parentComment.getAuthorId());
        reply.setCreateTime(LocalDateTime.now()); // 设置创建时间
        reply.setLikeCount(0); // 初始化点赞数

        commentService.save(reply);

        // 返回完整的评论数据
        return Result.ok()
                .data("reply", reply)
                .data("parentCommentId", commentId); // 同时返回父评论ID
    }

    // 删除评论
    @PostMapping("/delete/{commentId}")
    public Result deletePost(@PathVariable int commentId) {
        commentService.remove(new QueryWrapper<TorrentComment>().eq("post_id", commentId));
        boolean removed = commentService.removeById(commentId);
        return removed ? Result.ok() : Result.error(404).setMessage("删除评论失败");
    }

}