package com.ptp.ptplatform.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Date;

@Data
@NoArgsConstructor
@TableName("discount") // 指定表名为 discount
public class DISCOUNT {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id; // 主键ID

    @TableField(value = "name") // 折扣名称 比如五一节日
    private String name;

    @TableField(value = "start_time") // 开始时间
    private LocalDateTime startTime;

    @TableField(value = "end_time") // 结束时间
    private LocalDateTime endTime;

    @TableField(value = "discount_type") // 折扣方式
    private String discountType;
    // enum ('FREE', 'HALF', 'DOUBLE')
    // free 全部下载免费 half 下载消耗一半下载量 double 下载资源，上传用户获得双倍下载量

    @TableField(value = "create_time") // 创建时间
    private LocalDateTime createTime;

    @TableField(exist = false)
    private String status; // 状态字段（进行中、未开始、已过期）

    // 构造函数
    public DISCOUNT(String name, LocalDateTime startTime, LocalDateTime endTime, String discountType) {
        this.name = name;
        this.startTime = startTime;
        this.endTime = endTime;
        this.discountType = discountType;
        this.createTime = LocalDateTime.now(); // 默认为当前时间
    }

    public String getStatus() {
        LocalDateTime now = LocalDateTime.now();
        if (now.isBefore(startTime)) {
            return "未开始";
        } else if (now.isAfter(endTime)) {
            return "已过期";
        } else {
            return "进行中";
        }
    }

}
