package com.ptp.ptplatform.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Data
@TableName("help_comments")
public class HelpComment {
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;        // 使用包装类型以支持 null
    private Integer postId;
    private String authorId;
    private String content;
    private Integer likeCount;
    private LocalDateTime createTime;
    private Integer parentId;  // 新增字段，用于回复功能，0表示主评论，非0表示回复某条评论
    private String replyTo;
    private String ImageUrl;

    @TableField(exist = false)
    private List<HelpComment> replies = new ArrayList<>(); // 必须初始化

    // 确保有getter和setter
    public List<HelpComment> getReplies() {
        return replies;
    }

    public void setReplies(List<HelpComment> replies) {
        this.replies = replies;
    }
}
