package com.ptp.ptplatform.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.JSONPObject;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import lombok.Data;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.Date;

@Data
@TableName("torrent") // 使用MyBatis-Plus的注解指定表名
public class TORRENT {

    @Setter
    private Integer id;

    private String torrentName; // 文件名
    private String description; // 描述
    private String category; // 分类
    private String region; // 地区
    private String resolution; // 分辨率
    private String subtitle; // 字幕状态

    private Long size; // 种子对应文件大小
    private String hash; // torrent编码
    private String username; // 创建用户
    private String filePath;
    private int like_count;
    private int reply_count;

    @TableField(value = "create_time") // 使用@TableField注解处理时间字段
    private LocalDateTime createTime; // 创建时间

    public TORRENT(){

    }

    // 构造函数
    public TORRENT(String hash, String torrentName, String description, String category, String region, String resolution, String subtitle, Long size, String username, String filePath) {
        this.hash = hash;
        this.torrentName = torrentName;
        this.description = description;
        this.category = category;
        this.region = region;
        this.resolution = resolution;
        this.subtitle = subtitle;
        this.size = size;
        this.username = username;
        this.filePath = filePath;
        this.createTime = LocalDateTime.now();
        this.like_count = 0;
        this.reply_count = 0;
    }

    public void setLikeCount(int like_count) {
        this.like_count = like_count;
    }

    public int getLikeCount() {
        return this.like_count;
    }

    public long getSize() {
        return this.size;
    }
    public Integer getId(){
        return this.id;
    }
}