package com.ptp.ptplatform.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Data
@TableName("torrent_comments")
public class TorrentComment {
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    private Integer postId;
    private String authorId;
    private String content;
    private Integer likeCount;
    private LocalDateTime createTime;
    private Integer parentId;
    private String replyTo;

    @TableField(exist = false)
    private List<TorrentComment> replies = new ArrayList<>(); // 必须初始化

    // 确保有getter和setter
    public List<TorrentComment> getReplies() {
        return replies;
    }

    public void setReplies(List<TorrentComment> replies) {
        this.replies = replies;
    }
}