// 用户类
// @GeneratedValue(strategy = GenerationType.IDENTITY) 对于一些需要自动生成的主键id进行注解

package com.ptp.ptplatform.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ptp.ptplatform.utils.SizeCalculation;
import jakarta.persistence.*;
import lombok.Data;

import java.util.Date;

@Data
@Table(name = "user")
@TableName("user")
public class USER {

    @jakarta.persistence.Id
    private String username;
    private String password;

    @Enumerated(EnumType.STRING)
    private Authority authority;

    private int level; // 用户等级0-6

    @TableField("registTime")
    @Temporal(TemporalType.DATE)
    private Date registTime = new Date();

    @TableField("lastLogin")
    @Temporal(TemporalType.DATE)
    private Date lastLogin;

    private long upload;
    private long download;
    @TableField("shareRate")
    private double shareRate;//分享率 前端展示数据应该为 90.23%这种
    @TableField("magicPoints")
    private long magicPoints;// 魔力值

    public enum Authority {
        USER, ADMIN, LIMIT, BAN
    }

    // 函数
    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Authority getAuthority() {
        return authority;
    }

    public void setAuthority(Authority authority) {
        this.authority = authority;
    }

    public int getLevel() {
        return level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public Date getRegistTime() {
        return registTime;
    }

    public void setRegistTime(Date registTime) {
        this.registTime = registTime;
    }

    public Date getLastLogin() {
        return lastLogin;
    }

    public void setLastLogin(Date lastLogin) {
        this.lastLogin = lastLogin;
    }

    public long getUpload() {
        return upload;
    }

    public void setUpload(long upload) {
        this.upload = upload;
    }

    public long getDownload() {
        return download;
    }

    public void setDownload(long download) {
        this.download = download;
    }

    public double getShareRate() {
        return shareRate;
    }

    public void setShareRate(double shareRate) {
        this.shareRate = shareRate;
    }

    public long getMagicPoints() {
        return this.magicPoints;
    }

    public void setMagicPoints(long magicPoints) {
        this.magicPoints = magicPoints;
    }

    public USER() {
    }

    public USER(String username, String password, Authority authority) {
        this.username = username;
        this.password = password;
        this.authority = authority;
    }

    public USER(String username, String password, Date registTime) {
        this.username = username;
        this.registTime = registTime;

        this.password = password;

        this.authority = Authority.USER;
        this.level = 0;
        this.lastLogin = null;
        this.upload = SizeCalculation.GBToByte(1); //默认有1024mb的下载量
        this.download = 1;
        this.shareRate = 1;
        this.magicPoints = 0;
    }

    //对上传量下载量的处理 返回更新后的数据结果
    public long updateUpload(long addUpload) {
        this.upload += addUpload;
        this.shareRate = (double) this.upload / this.download;
        return this.upload;
    }

    public long updateDownload(long addDownload) {
        this.download += addDownload;
        this.shareRate = (double) this.upload / this.download;
        return this.download;
    }

    //生成邀请码，魔力值扣除
    public void generateInviteCode() {
        this.magicPoints -= 10;
    }

    // 每天运行的计算魔力值程序
    // 添加种子，验证同一用户的全部种子存活与否
    // 也是可以读取json文件进行操作
    public void addMagicPoints(long addMagicPoints) {
        this.magicPoints += addMagicPoints;
    }

    public void reduceMagicPoints(long reduceMagicPoints) {
        this.magicPoints -= reduceMagicPoints;
    }

    //分享率要至少大于0.5
    public boolean allowDownload(long fileSize) {
        if (this.upload / (fileSize + this.download) < 0.5) {
            return false;
        }

        // 避免除以零
        if (download == 0) return true;

        // 计算当前分享率
        double currentRatio = (double)upload / download;

        // 计算下载后的分享率
        double newRatio = (double)upload / (download + fileSize);

        // 设置阈值，例如0.5
        return newRatio >= 0.5;

    }

}