package com.ptp.ptplatform.mapper;

import com.ptp.ptplatform.entity.ANNOUNCEMENT;
import org.apache.ibatis.annotations.*;

import java.util.List;

@Mapper
public interface AnnouncementMapper {
    // 使用注解方式实现
    // 插入新公告（返回自增ID）
    @Insert("INSERT INTO announcement (title, content, create_time) " +
            "VALUES (#{title}, #{content}, #{createTime})")
    @Options(useGeneratedKeys = true, keyProperty = "id") // 获取自增ID
    int insert(ANNOUNCEMENT announcement);

    @Select("SELECT id, title, content, create_time FROM announcement WHERE id = #{id}")
    @Results({
            @Result(property = "id", column = "id"),
            @Result(property = "title", column = "title"),
            @Result(property = "content", column = "content"),
            @Result(property = "createTime", column = "create_time")
    })
    ANNOUNCEMENT selectById(Integer id);

    @Select("SELECT id, title, content, create_time FROM announcement ORDER BY create_time DESC LIMIT #{limit}")
    @Results({
            @Result(property = "id", column = "id"),
            @Result(property = "title", column = "title"),
            @Result(property = "content", column = "content"),
            @Result(property = "createTime", column = "create_time")
    })
    List<ANNOUNCEMENT> selectLatest(int limit);

    @Select("SELECT id, title, content, create_time FROM announcement ORDER BY create_time DESC")
    @Results({
            @Result(property = "id", column = "id"),
            @Result(property = "title", column = "title"),
            @Result(property = "content", column = "content"),
            @Result(property = "createTime", column = "create_time")
    })
    List<ANNOUNCEMENT> selectAll();
}