package com.ptp.ptplatform.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ptp.ptplatform.entity.DISCOUNT;
import org.apache.ibatis.annotations.*;

import java.time.LocalDateTime;
import java.util.*;

@Mapper
public interface DiscountMapper extends BaseMapper<DISCOUNT> {

    // 查询当前进行中的折扣
    @Select("SELECT * FROM discount WHERE start_time <= NOW() AND end_time >= NOW()")
    DISCOUNT selectCurrentDiscount();

    // 查询全部折扣
    @Select("SELECT * FROM discount")
    List<DISCOUNT> selectAllDiscounts();

    // 插入新折扣
    @Insert("INSERT INTO discount (start_time, end_time, discount_type, name) VALUES (#{startTime}, #{endTime}, #{discountType}, #{name})")
    int insertDiscount(DISCOUNT discount);

    // 删除折扣
    @Delete("DELETE FROM discount WHERE id = #{id}")
    int deleteDiscountById(int id);

    // 查询是否有重叠时间的折扣
    @Select("SELECT COUNT(*) FROM discount WHERE (start_time < #{endTime} AND end_time > #{startTime})")
    int checkOverlapTime(LocalDateTime startTime, LocalDateTime endTime);
}