package com.ptp.ptplatform.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ptp.ptplatform.entity.DOWNLOAD_TORRENT;
import org.apache.ibatis.annotations.*;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;

import org.apache.ibatis.annotations.*;

import java.util.List;

@Mapper
public interface DownloadTorrentMapper extends BaseMapper<DOWNLOAD_TORRENT> {
    // 获取对应用户的保种积分
    @Select("SELECT * FROM download_torrent WHERE username = #{username}")
    List<DOWNLOAD_TORRENT> selectByUsername(String username);

    // 新建数据
    @Insert("INSERT INTO download_torrent (username, torrentid, finished, created, updated, fileSize) " +
            "VALUES (#{username}, #{torrentid}, #{finished}, #{created}, #{updated}, #{fileSize})")
    int insertDownloadTorrent(DOWNLOAD_TORRENT downloadTorrent);

    @Update("UPDATE download_torrent SET torrentid = #{torrentid}, finished = #{finished}, updated = #{updated}, fileSize = #{fileSize} " +
            "WHERE id = #{id}")
    int updateDT(DOWNLOAD_TORRENT downloadTorrent);

    @Select("SELECT DISTINCT username FROM download_torrent WHERE torrentid = #{torrentId}")
    List<String> findUsersWhoDownloaded(Integer torrentId);

    @Select("SELECT COUNT(*) FROM download_torrent WHERE username = #{username} AND torrentid = #{torrentId}")
    int countUserDownloads(String username, Integer torrentId);

    @Select("SELECT * FROM download_torrent WHERE username = #{username}")
    List<DOWNLOAD_TORRENT> findByUsername(@Param("username") String username);

    @Select("SELECT DISTINCT username FROM download_torrent WHERE torrentid = #{torrentId}")
    List<String> findUsersByTorrentId(@Param("torrentId") Integer torrentId);
    // 添加删除方法
    @Delete("DELETE FROM download_torrent WHERE torrentid = #{torrentId}")
    int deleteByTorrentId(@Param("torrentId") int torrentId);

}
