package com.ptp.ptplatform.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ptp.ptplatform.entity.INVITE_CODE;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.springframework.web.service.annotation.PutExchange;

import java.util.List;

@Mapper
public interface InviteCodeMapper extends BaseMapper<INVITE_CODE> {
    //查询
    @Select("SELECT * FROM invite_code WHERE code = #{code}")
    INVITE_CODE selectByCode(String code);

    @Select("SELECT * FROM invite_code WHERE generateUser = #{username}")
    List<INVITE_CODE> selectByUser(String username);

    @Update("UPDATE invite_code SET isused = true WHERE code = #{code}")
    int updateCodeUser(String code);

    // 插入新数据
    @Insert("INSERT INTO invite_code (code, generateUser, isUsed) VALUES (#{code}, #{generateUser}, #{isUsed})")
    int insertInviteCode(INVITE_CODE inviteCode);
}
