package com.ptp.ptplatform.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ptp.ptplatform.entity.RECOMMEND_HISTORY;
import org.apache.ibatis.annotations.*;

import java.util.Set;

@Mapper
public interface RecommendHistoryMapper extends BaseMapper<RECOMMEND_HISTORY> {

    @Select("SELECT torrent_id FROM user_recommendation_history WHERE username = #{username}")
    Set<Integer> findRecommendedTorrentIdsByUser(@Param("username") String username);

    @Insert("INSERT INTO user_recommendation_history(username, torrent_id, recommended_at, shown, clicked) " +
            "VALUES(#{username}, #{torrentId}, #{recommendedAt}, #{shown}, #{clicked})")
    @Options(useGeneratedKeys = true, keyProperty = "id")
    int insertHistory(RECOMMEND_HISTORY history);

    @Update("UPDATE user_recommendation_history SET shown = TRUE WHERE username = #{username} AND torrent_id = #{torrentId}")
    int markAsShown(@Param("username") String username, @Param("torrentId") Integer torrentId);

    @Update("UPDATE user_recommendation_history SET clicked = TRUE WHERE username = #{username} AND torrent_id = #{torrentId}")
    int markAsClicked(@Param("username") String username, @Param("torrentId") Integer torrentId);

    @Select("SELECT COUNT(*) FROM user_recommendation_history WHERE username = #{username} AND torrent_id = #{torrentId}")
    int existsByUserAndTorrent(@Param("username") String username, @Param("torrentId") Integer torrentId);
}
