package com.ptp.ptplatform.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ptp.ptplatform.entity.TORRENT;
import org.apache.ibatis.annotations.*;

import java.util.List;

public interface TorrentMapper extends BaseMapper<TORRENT> {
    // 根据hash查询Torrent
    @Select("SELECT * FROM torrent WHERE hash = #{hash}")
    TORRENT selectByHash(String hash);

    @Select("SELECT * FROM torrent WHERE id = #{id}")
    TORRENT selectByID(int id);

    // Mapper接口
    @Select("SELECT * FROM torrent ORDER BY create_time DESC LIMIT #{offset}, #{size}")
    List<TORRENT> selectAllTorrentWithPage(@Param("offset") int offset, @Param("size") int size);

    @Select("SELECT COUNT(*) FROM torrent")
    int countAllTorrent();

    @Select("SELECT * FROM torrent WHERE category = #{category}")
    List<TORRENT> selectTorrentByCategory(String category);

    @Select("SELECT * FROM torrent WHERE torrent_name LIKE CONCAT('%', #{key}, '%')")
    List<TORRENT> selectTorrentByKey(String key);

    @Select("SELECT * FROM torrent WHERE username = #{username}")
    List<TORRENT> selectTorrentByUsername(String username);

    //分页查询部分
    // 在TorrentMapper.java中添加以下方法

    // 分页查询特定分类
    @Select("SELECT * FROM torrent WHERE category = #{category} ORDER BY create_time DESC LIMIT #{offset}, #{size}")
    List<TORRENT> selectTorrentByCategoryWithPage(@Param("category") String category,
                                                  @Param("offset") int offset,
                                                  @Param("size") int size);

    @Select("SELECT COUNT(*) FROM torrent WHERE category = #{category}")
    int countByCategory(@Param("category") String category);

    // 分页搜索关键字
    @Select("SELECT * FROM torrent WHERE torrent_name LIKE CONCAT('%',#{key},'%') OR description LIKE CONCAT('%',#{key},'%') ORDER BY create_time DESC LIMIT #{offset}, #{size}")
    List<TORRENT> selectTorrentByKeyWithPage(@Param("key") String key,
                                             @Param("offset") int offset,
                                             @Param("size") int size);

    @Select("SELECT COUNT(*) FROM torrent WHERE torrent_name LIKE CONCAT('%',#{key},'%') OR description LIKE CONCAT('%',#{key},'%')")
    int countByKey(@Param("key") String key);

    // 分页查询用户种子
    @Select("SELECT * FROM torrent WHERE username = #{username} ORDER BY create_time DESC LIMIT #{offset}, #{size}")
    List<TORRENT> selectTorrentByUsernameWithPage(@Param("username") String username,
                                                  @Param("offset") int offset,
                                                  @Param("size") int size);

    @Select("SELECT COUNT(*) FROM torrent WHERE username = #{username}")
    int countByUsername(@Param("username") String username);

    // 插入Torrent
    @Options(useGeneratedKeys = true, keyProperty = "id")
    @Insert("INSERT INTO torrent (torrent_name, description, category, region, resolution, subtitle, size, hash, username, create_time, file_path) " +
            "VALUES (#{torrentName}, #{description}, #{category}, #{region}, #{resolution}, #{subtitle}, #{size}, #{hash}, #{username}, #{createTime}, #{filePath})")
    int insertTorrent(TORRENT torrent);

    // 更新Torrent信息
    @Update("UPDATE torrent SET torrent_name = #{torrentName}, description = #{description}, category = #{category}, " +
            "tags = #{tags}, size = #{size}, username = #{username} WHERE hash = #{hash}")
    int updateTorrent(TORRENT torrent);

    // 删除Torrent
    @Delete("DELETE FROM torrent WHERE id = #{id}")
    int deleteTorrent(int id);

    @Select("SELECT * FROM torrent WHERE id = #{torrentId}")
    TORRENT findById(@Param("torrentId") Integer torrentId);

    @Select("SELECT * FROM torrent ORDER BY like_count DESC LIMIT #{limit}")
    List<TORRENT> findPopularTorrents(@Param("limit") int limit);

}