package com.ptp.ptplatform.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ptp.ptplatform.entity.USER;
import org.apache.ibatis.annotations.*;

import java.util.*;


@Mapper
public interface UserMapper extends BaseMapper<USER> {
    // 查询
    @Select("SELECT * FROM user WHERE username = #{username}")
    USER selectByUsername(String username);

    @Select("SELECT * FROM user WHERE username = #{username} AND password = #{password}")
    USER selectByUsernameAndPassword(String username, String password);

    @Select("SELECT * FROM user WHERE username LIKE CONCAT('%', #{key}, '%') AND username != #{username}")
    List<USER> searchUsername(String username, String key);

    @Select("SELECT username, authority, level, registTime, lastLogin, upload, download, shareRate, magicPoints FROM user")
    List<USER> selectAllUsers();

    @Select("SELECT * FROM user WHERE username = #{username}")
    USER findByUsername(@Param("username") String username);

    // 注册用户
    @Insert("INSERT INTO user (username, password, registTime) " +
            "VALUES (#{username}, #{password}, #{registTime})")
    int insertUser(USER user);

    // 更新用户信息
    @Update("UPDATE user SET " +
            "password = #{password}, " +
            "authority = #{authority}, " +
            "level = #{level}, " +
            "lastLogin = #{lastLogin}, " +
            "upload = #{upload}, " +
            "download = #{download}, " +
            "shareRate = #{shareRate}, " +
            "magicPoints = #{magicPoints} " +
            "WHERE username = #{username}")
    int updateUser(USER user);
}
