package com.ptp.ptplatform.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.turn.ttorrent.client.SimpleClient;
import com.turn.ttorrent.common.TorrentStatistic;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class ClientService {
    SimpleClient client = new SimpleClient();
    private List<String[]> tasks = new ArrayList<>();

    public boolean downloadTorrent(String torrentFilePath, String outputDirectory, String username) throws Exception {
        InetAddress address = InetAddress.getLocalHost();
        try {
            client.downloadTorrent(torrentFilePath, outputDirectory, address);
            tasks.add(new String[] {username, torrentFilePath});
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public TorrentStatistic getStatistics(String torrentFilePath) throws Exception {
        return client.getStatistics(torrentFilePath);
    }

    // 修改后的获取下载进度方法
    public double getDownloadProgress(String torrentFilePath) throws Exception {
        try {
            TorrentStatistic stats = client.getStatistics(torrentFilePath);
            if (stats == null) {
                // 如果统计信息为空，可能下载已完成
                return 1.0; // 返回100%表示已完成
            }
            double progress = stats.getPercentageDownloaded();
            // 确保进度在0-1之间
            return Math.max(0, Math.min(1, progress));
        } catch (Exception e) {
            // 如果出现异常，可能下载已完成
            return 1.0;
        }
    }

    public List<String[]> getTasks() {
        return this.tasks;
    }
}