package com.ptp.ptplatform.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.ptp.ptplatform.service.serializer.PeerUIDDeserializer;
import com.ptp.ptplatform.service.serializer.PeerUIDSerializer;
import com.turn.ttorrent.common.PeerUID;
import com.turn.ttorrent.tracker.TrackedTorrent;
import com.turn.ttorrent.tracker.Tracker;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

//封装的对tracker的操作
@Service
public class TrackerService {
    private final ObjectMapper objectMapper;
    private Tracker tracker;

    public TrackerService(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        registerPeerUIDModule(); // 注册 PeerUID 的序列化器
    }

    private void registerPeerUIDModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(PeerUID.class, new PeerUIDSerializer());
        module.addDeserializer(PeerUID.class, new PeerUIDDeserializer());
        objectMapper.registerModule(module);
    }

    public void startTracker() throws Exception {
        File trackerFile = new File("tracker.json");
        if (trackerFile.exists()) {
            try {
                tracker = objectMapper.readValue(trackerFile, Tracker.class);
                System.out.println("Tracker loaded from file.");
            } catch (Exception e) {
                System.err.println("Failed to load tracker, creating new one: " + e.getMessage());
                tracker = new Tracker(6969);
            }
        } else {
            tracker = new Tracker(6969);
        }

        // 加载 .torrent 文件
        String torrentDirectory = System.getProperty("user.dir") + File.separator + "torrents";
        File[] torrentFiles = new File(torrentDirectory).listFiles((dir, name) -> name.endsWith(".torrent"));

        if (torrentFiles != null) {
            for (File file : torrentFiles) {
                try {
                    TrackedTorrent tt = TrackedTorrent.load(file);
                    tracker.announce(tt);
                    System.out.println("Added torrent: " + file.getName());
                } catch (Exception e) {
                    System.err.println("Failed to load torrent " + file.getName() + ": " + e.getMessage());
                }
            }
        }

        tracker.setAcceptForeignTorrents(true);
        tracker.start(true);
    }

    public void serTracker() throws IOException {
        if (tracker != null) {
            objectMapper.writeValue(new File("tracker.json"), tracker);
        }
    }

    public void stopTracker() throws IOException {
        if (tracker != null) {
            objectMapper.writeValue(new File("tracker.json"), tracker);
//            tracker.stop();
        }
    }

    public Collection<TrackedTorrent> getTrackedTorrents() {
        return tracker.getTrackedTorrents();
    }

    public TrackedTorrent getTrackedTorrent(String hash) {
        return tracker.getTrackedTorrent(hash);
    }

    public TrackedTorrent addTrackedTorrent(String filePath) throws IOException {
        File file = new File(filePath);
        return tracker.announce(TrackedTorrent.load(file));
    }
}