package com.ptp.ptplatform.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ptp.ptplatform.entity.HelpComment;
import com.ptp.ptplatform.entity.HelpPost;
import com.ptp.ptplatform.entity.Notification;
import com.ptp.ptplatform.mapper.HelpCommentMapper;
import com.ptp.ptplatform.mapper.HelpPostMapper;
import com.ptp.ptplatform.service.HelpCommentService;
import com.ptp.ptplatform.service.NotificationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.List;

@Service
public class HelpCommentServiceImpl
        extends ServiceImpl<HelpCommentMapper, HelpComment>
        implements HelpCommentService {
    @Autowired
    private HelpCommentMapper helpCommentMapper;

    @Autowired
    private HelpPostMapper helpPostMapper;

    @Autowired
    private NotificationService notificationService;

    @Override
    @Transactional
    public void incrementLike(int commentId) {
        this.update(null,
                new com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper<HelpComment>()
                        .eq("id", commentId)
                        .setSql("like_count = like_count + 1")
        );
    }

    @Override
    @Transactional(readOnly = true)
    public List<HelpComment> getReplies(int parentId) {
        return this.baseMapper.selectList(
                new QueryWrapper<HelpComment>()
                        .eq("parent_id", parentId)
                        .orderByAsc("create_time")
        );
    }
    @Override
    public long countByPostId(Integer postId) {
        return count(new QueryWrapper<HelpComment>()
                .eq("post_id", postId)); // 只按post_id统计
    }

    @Override
    public void commentOnHelpPost(HelpComment comment) {
        // 1. 保存评论
        helpCommentMapper.insert(comment);

        // 2. 通知帖子作者
        HelpPost post = helpPostMapper.selectById(comment.getPostId());
        if (post != null
                && !post.getAuthorId().equals(comment.getAuthorId())) {
            Notification n = new Notification();
            n.setUserId(post.getAuthorId());
            n.setType("POST_REPLY");
            n.setTitle("您的帖子有了新回复");
            n.setContent("用户 "
                    + comment.getAuthorId()
                    + " 评论了您的帖子: \""
                    + comment.getContent()
                    + "\"");
            n.setTargetId(post.getId());
            n.setTargetType("HelpPost");
            notificationService.saveNotification(n);
        }
    }

    /**
     * 用户回复已有评论
     */
    @Override
    public void replyComment(HelpComment reply) {
        // 1. 保存子评论
        helpCommentMapper.insert(reply);

        // 2. 通知父评论作者
        HelpComment parent = helpCommentMapper.selectById(reply.getParentId());
        if (parent != null
                && !parent.getAuthorId().equals(reply.getAuthorId())) {
            Notification n = new Notification();
            n.setUserId(parent.getAuthorId());
            n.setType("COMMENT_REPLY");
            n.setTitle("您的评论有了新回复");
            n.setContent("用户 "
                    + reply.getAuthorId()
                    + " 回复了您的评论: \""
                    + reply.getContent()
                    + "\"");
            n.setTargetId(parent.getId());
            n.setTargetType("HelpComment");
            notificationService.saveNotification(n);
        }
    }
}