package com.ptp.ptplatform.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ptp.ptplatform.entity.Notification;
import com.ptp.ptplatform.mapper.NotificationMapper;
import com.ptp.ptplatform.service.NotificationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;

@Service
public class NotificationServiceImpl implements NotificationService {
    @Autowired
    private NotificationMapper notificationMapper;

    @Override
    public void saveNotification(Notification n) {
        n.setCreateTime(LocalDateTime.now());
        n.setIsRead(false);
        notificationMapper.insert(n);
    }

    @Override
    public List<Notification> listByUser(String userId) {
        return notificationMapper.selectList(
                new QueryWrapper<Notification>()
                        .eq("user_id", userId)
                        .orderByDesc("create_time")
        );
    }

    @Override
    @Transactional
    public Notification markAsRead(Integer id) {
        // 先查询通知是否存在
        Notification notification = notificationMapper.selectById(id);
        if (notification == null) {
            throw new RuntimeException("通知不存在");
        }

        // 更新通知状态
        Notification update = new Notification();
        update.setId(id);
        update.setIsRead(true);
//        update.setReadTime(LocalDateTime.now());

        int affected = notificationMapper.updateById(update);
        if (affected == 0) {
            throw new RuntimeException("标记已读失败");
        }

        // 返回更新后的通知对象
        return notificationMapper.selectById(id);
    }
}