package com.ptp.ptplatform.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ptp.ptplatform.entity.RequestComment;
import com.ptp.ptplatform.entity.RequestPost;
import com.ptp.ptplatform.entity.Notification;
import com.ptp.ptplatform.mapper.RequestCommentMapper;
import com.ptp.ptplatform.mapper.RequestPostMapper;
import com.ptp.ptplatform.service.RequestCommentService;
import com.ptp.ptplatform.service.NotificationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.List;

@Service
public class RequestCommentServiceImpl
        extends ServiceImpl<RequestCommentMapper, RequestComment>
        implements RequestCommentService {
    @Autowired
    private RequestCommentMapper requestCommentMapper;

    @Autowired
    private RequestPostMapper requestPostMapper;

    @Autowired
    private NotificationService notificationService;

    @Override
    @Transactional
    public void incrementLike(int commentId) {
        this.update(null,
                new com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper<RequestComment>()
                        .eq("id", commentId)
                        .setSql("like_count = like_count + 1")
        );
    }

    @Override
    @Transactional(readOnly = true)
    public List<RequestComment> getReplies(int parentId) {
        return this.baseMapper.selectList(
                new QueryWrapper<RequestComment>()
                        .eq("parent_id", parentId)
                        .orderByAsc("create_time")
        );
    }
    @Override
    public long countByPostId(Integer postId) {
        return count(new QueryWrapper<RequestComment>()
                .eq("post_id", postId)); // 只按post_id统计
    }

    @Override
    public void commentOnRequestPost(RequestComment comment) {
        // 1. 保存评论
        requestCommentMapper.insert(comment);

        // 2. 通知帖子作者
        RequestPost post = requestPostMapper.selectById(comment.getPostId());
        if (post != null
                && !post.getAuthorId().equals(comment.getAuthorId())) {
            Notification n = new Notification();
            n.setUserId(post.getAuthorId());
            n.setType("POST_REPLY");
            n.setTitle("您的帖子有了新回复");
            n.setContent("用户 "
                    + comment.getAuthorId()
                    + " 评论了您的帖子: \""
                    + comment.getContent()
                    + "\"");
            n.setTargetId(post.getId());
            n.setTargetType("HelpPost");
            notificationService.saveNotification(n);
        }
    }

    /**
     * 用户回复已有评论
     */
    @Override
    public void replyComment(RequestComment reply) {
        // 1. 保存子评论
        requestCommentMapper.insert(reply);

        // 2. 通知父评论作者
        RequestComment parent = requestCommentMapper.selectById(reply.getParentId());
        if (parent != null
                && !parent.getAuthorId().equals(reply.getAuthorId())) {
            Notification n = new Notification();
            n.setUserId(parent.getAuthorId());
            n.setType("COMMENT_REPLY");
            n.setTitle("您的评论有了新回复");
            n.setContent("用户 "
                    + reply.getAuthorId()
                    + " 回复了您的评论: \""
                    + reply.getContent()
                    + "\"");
            n.setTargetId(parent.getId());
            n.setTargetType("RequestComment");
            notificationService.saveNotification(n);
        }
    }
}