package com.ptp.ptplatform.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ptp.ptplatform.entity.TORRENT;
import com.ptp.ptplatform.mapper.TorrentMapper;
import com.ptp.ptplatform.service.TorrentService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TorrentServiceImpl extends ServiceImpl<TorrentMapper, TORRENT> implements TorrentService {

    @Override

    public TORRENT getTorrentById(Integer id) {
        return this.getById(id); // 直接调用 MyBatis-Plus 提供的 getById 方法
    }
    @Override
    @Transactional
    public void incrementLike(int postId) {
        this.update(null,
                new com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper<TORRENT>()
                        .eq("id", postId)
                        .setSql("like_count = like_count + 1")
        );
    }

    @Override
    @Transactional
    public void incrementReplyCount(int postId) {
        this.update(null,
                new com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper<TORRENT>()
                        .eq("id", postId)
                        .setSql("reply_count = reply_count + 1")
        );
    }

}