package com.ptp.ptplatform.service.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.turn.ttorrent.common.PeerUID;

import java.io.IOException;
import java.net.InetSocketAddress;

public class PeerUIDDeserializer extends JsonDeserializer<PeerUID> {
    @Override
    public PeerUID deserialize(JsonParser jsonParser, DeserializationContext deserializationContext)
            throws IOException, JsonProcessingException {
        JsonNode node = jsonParser.getCodec().readTree(jsonParser);

        String torrentHash = node.get("torrentHash").asText();

        JsonNode addressNode = node.get("address");
        String host = addressNode.get("host").asText();
        int port = addressNode.get("port").asInt();

        InetSocketAddress address = new InetSocketAddress(host, port);
        return new PeerUID(address, torrentHash);
    }
}
